/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.http.RequestArrayBinary;
import org.maachang.util.AnalysisUtil;
import org.maachang.util.StringUtil;

public class ReadHttpdRequest {
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String CHUNKED = "chunked";
    private static final String CHARSET = "UTF8";
    private static final byte[] ENTER = new byte[]{13, 10};
    private static final byte[] END_HEADER = new byte[]{13, 10, 13, 10};

    private ReadHttpdRequest() {
    }

    public static final RequestInfo receiveHttpRequest(InputStream stream, int seqId) throws Exception {
        RequestInfo ret = ReadHttpdRequest.readHeader(stream);
        if ("POST".equals(ret.getMethod())) {
            ReadHttpdRequest.readResponseByBody(ret, stream);
        }
        return ret;
    }

    private static final RequestInfo readHeader(InputStream stream) throws Exception {
        int endPoint = 0;
        int endHeaderLen = END_HEADER.length;
        RequestArrayBinary buf = new RequestArrayBinary();
        while (true) {
            int d;
            if ((d = stream.read()) <= -1) {
                if (buf.getLength() <= 0) {
                    return null;
                }
                return ReadHttpdRequest.convertHttpdHeader(buf.getBinary(), buf.getLength());
            }
            buf.write(d &= 0xFF);
            if (d == (END_HEADER[endPoint] & 0xFF)) {
                if (++endPoint < endHeaderLen) continue;
                if (buf.getLength() <= 0) {
                    return null;
                }
                return ReadHttpdRequest.convertHttpdHeader(buf.getBinary(), buf.getLength());
            }
            endPoint = 0;
        }
    }

    private static final boolean readResponseByBody(RequestInfo req, InputStream stream) throws Exception {
        RequestArrayBinary buf = new RequestArrayBinary();
        if (req.headerSize(TRANSFER_ENCODING) == 1) {
            String s = req.getHeader(TRANSFER_ENCODING, 0);
            if (!CHUNKED.equals(s)) {
                throw new IOException("\u4e0d\u6b63\u306a[Transfer-Encoding=" + s + "]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            ReadHttpdRequest.readBodyByChunked(buf, stream);
        } else if (req.headerSize(CONTENT_LENGTH) == 1) {
            String s = req.getHeader(CONTENT_LENGTH, 0);
            if (s == null || s.length() <= 0) {
                throw new IOException("\u4e0d\u6b63\u306a[Content-Length]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            int contentLength = Integer.parseInt(s);
            if (contentLength <= -1) {
                throw new IOException("\u53d7\u4fe1\u30c7\u30fc\u30bf\u9577[" + contentLength + "]\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (contentLength == 0) {
                return false;
            }
            ReadHttpdRequest.readBodyByLength(buf, contentLength, stream);
        } else {
            ReadHttpdRequest.readBodyByNoSetting(buf, stream);
        }
        if (buf.getLength() > 0) {
            req.setBody(buf.getBinary(buf.getLength()));
            return true;
        }
        return false;
    }

    private static final void readBodyByChunked(RequestArrayBinary buf, InputStream stream) throws Exception {
        int len = -1;
        int enterPos = 0;
        int pos = 0;
        int cnt = 0;
        byte[] headBuf = new byte[32];
        while (true) {
            int d;
            if ((d = stream.read()) <= -1) {
                throw new IOException("\u4e0d\u6b63\u306achunked\u7d42\u7aef\u3092\u691c\u51fa\u3057\u307e\u3057\u305f(" + len + ")");
            }
            d &= 0xFF;
            ++cnt;
            if (len == -1) {
                if (d == (ENTER[enterPos] & 0xFF)) {
                    if (++enterPos < ENTER.length) continue;
                    if (pos > 0) {
                        String chLen = new String(headBuf, 0, pos, CHARSET);
                        len = ReadHttpdRequest.convertChunkedDataLength(chLen);
                        if (len == 0) {
                            int exitCnt = 0;
                            while (true) {
                                if (stream.available() <= 0) {
                                    continue;
                                }
                                stream.read();
                                if (++exitCnt >= ENTER.length) break;
                            }
                            return;
                        }
                        pos = 0;
                        enterPos = 0;
                        continue;
                    }
                    enterPos = 0;
                    continue;
                }
                if (enterPos >= 1) {
                    throw new IOException("\u4e0d\u6b63\u306achunked\u30c7\u30fc\u30bf\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                }
                headBuf[pos] = (byte)d;
                ++pos;
                continue;
            }
            buf.write(d);
            if (len > ++pos) continue;
            len = -1;
            pos = 0;
            enterPos = 0;
        }
    }

    private static final void readBodyByLength(RequestArrayBinary buf, int contentLength, InputStream stream) throws Exception {
        int pnt = 0;
        do {
            int d;
            if ((d = stream.read()) <= -1) {
                return;
            }
            buf.write(d);
        } while (contentLength > ++pnt);
    }

    private static final void readBodyByNoSetting(RequestArrayBinary buf, InputStream stream) throws Exception {
        int pnt = 0;
        int d;
        while ((d = stream.read()) > -1) {
            buf.write(d);
            ++pnt;
        }
        return;
    }

    private static final int convertChunkedDataLength(String s) throws Exception {
        try {
            return Integer.parseInt(s, 16);
        }
        catch (Exception e) {
            if (s == null || s.length() <= 0) {
                throw new IOException("\u4e0d\u6b63\u306achunked\u30d8\u30c3\u30c0\u6570\u5024\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            throw new IOException("\u4e0d\u6b63\u306achunked\u30d8\u30c3\u30c0\u6570\u5024[" + s + "]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
        }
    }

    private static final RequestInfo convertHttpdHeader(byte[] binary, int endPos) throws Exception {
        RequestInfo ret = new RequestInfo();
        int p = 0;
        int b = 0;
        int line = 0;
        int enterLen = ENTER.length;
        while (true) {
            if ((p = AnalysisUtil.binaryIndexOf(binary, ENTER, b, endPos)) == -1) {
                if (b >= endPos) break;
                p = endPos;
            }
            String one = new String(binary, b, p - b, CHARSET);
            b = p + enterLen;
            if (line == 0) {
                ReadHttpdRequest.convertHttpExecutionAndVersion(ret, one);
                if (ret.getVersion().endsWith("0.9")) {
                    return ret;
                }
            } else {
                ReadHttpdRequest.convertHttpHeader(ret, one);
            }
            if (p >= endPos) break;
            ++line;
        }
        return ret;
    }

    private static final void convertHttpExecutionAndVersion(RequestInfo out, String oneLine) {
        int pos1 = oneLine.indexOf(" ");
        int pos2 = oneLine.indexOf(" ", pos1 + 1);
        String exec = oneLine.substring(0, pos1);
        String url = oneLine.substring(pos1 + 1, pos2);
        String version = oneLine.substring(pos2 + 1, oneLine.length());
        out.setMethod(exec.trim());
        out.setUrl(url.trim());
        out.setVersion(version.trim());
    }

    private static final void convertHttpHeader(RequestInfo out, String oneLine) {
        int p = oneLine.indexOf(":");
        if (p == -1) {
            return;
        }
        String key = oneLine.substring(0, p).trim();
        if ((oneLine = oneLine.substring(++p + 1, oneLine.length())) == null || (oneLine = oneLine.trim()).length() <= 0) {
            out.addHeader(key, null);
        } else if (key.indexOf("User-Agent") != -1 || key.indexOf("Modified") != -1 || key.indexOf("Date") != -1) {
            out.putHeader(key, oneLine);
        } else if (oneLine.indexOf(",") != -1) {
            ArrayList<String> lst = StringUtil.cutString(oneLine, ",");
            int len = lst.size();
            int i = 0;
            while (i < len) {
                String o;
                if (i == 0) {
                    o = lst.get(i).trim();
                    if (o.length() > 0) {
                        int sp = o.indexOf(" ");
                        if (sp != -1) {
                            boolean flg = false;
                            int j = 0;
                            while (j < sp) {
                                char c = o.charAt(j);
                                if (c == '\"' || c == '\'') {
                                    flg = true;
                                    break;
                                }
                                ++j;
                            }
                            if (flg) {
                                out.addHeader(key, o);
                            } else {
                                out.addHeader(key, o.substring(0, sp).trim());
                                out.addHeader(key, o.substring(sp + 1).trim());
                            }
                        } else {
                            out.addHeader(key, o);
                        }
                    }
                } else {
                    o = lst.get(i).trim();
                    if (o.length() > 0) {
                        out.addHeader(key, o);
                    }
                }
                ++i;
            }
        } else if ((oneLine = oneLine.trim()).length() > 0) {
            out.addHeader(key, oneLine);
        }
    }
}

