/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.http;

import java.io.IOException;

class RequestArrayBinary {
    private static final int MAX_MBYTE = 8;
    protected static final int MAX_LENGTH = 0x800000;
    private static final int BUFFER = 4096;
    private byte[] binary = new byte[4096];
    private int length = 0;

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.binary = null;
        this.length = 0;
    }

    public void reset() {
        if (this.binary.length == 4096) {
            this.length = 0;
        } else {
            this.binary = new byte[4096];
            this.length = 0;
        }
    }

    public void write(int b) throws Exception {
        if (this.length >= 0x800000) {
            this.destroy();
            throw new IOException("\u53d7\u4fe1\u30c7\u30fc\u30bf\u9577\u304c\u6700\u5927\u5024[8388608]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.binary.length <= this.length) {
            byte[] t = this.binary;
            int iLen = t.length * 2;
            if (iLen >= 0x800000) {
                iLen = 0x800000;
            }
            this.binary = new byte[iLen];
            System.arraycopy(t, 0, this.binary, 0, t.length);
            byte[] byArray = null;
        }
        this.binary[this.length] = (byte)(b & 0xFF);
        ++this.length;
    }

    public byte getByte(int no) {
        return this.binary[no];
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public byte[] getBinary(int length) {
        if (length <= 0) {
            length = this.length;
        }
        if (this.length < length) {
            length = this.length;
        }
        byte[] ret = new byte[length];
        System.arraycopy(this.binary, 0, ret, 0, length);
        return ret;
    }

    public int getLength() {
        return this.length;
    }
}

