/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.ResponseInfo;
import org.maachang.proxy.engine.net.http.CloseClientException;
import org.maachang.proxy.engine.net.http.ConnectionInfo;
import org.maachang.proxy.engine.net.server.ExpireServerConnectException;
import org.maachang.proxy.engine.net.server.ReadHttpResponse;

public class HttpConnector {
    private Socket socket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private ConnectionInfo connectionInfo = null;
    private long lastAccess = -1L;

    public HttpConnector() {
    }

    public HttpConnector(Socket socket) throws Exception {
        if (socket == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.socket = socket;
        this.inputStream = new BufferedInputStream(socket.getInputStream());
        this.outputStream = new BufferedOutputStream(socket.getOutputStream());
        this.connectionInfo = null;
        this.lastAccess = System.currentTimeMillis();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
        this.lastAccess = -1L;
        this.connectionInfo = null;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public void setLastAccess() {
        this.lastAccess = System.currentTimeMillis();
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void send(RequestInfo request) throws Exception {
        if (!this.isUse()) {
            throw new ExpireServerConnectException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        request.outputStream(this.isLocal(), this.outputStream);
    }

    public ResponseInfo receive(OutputStream out, ResponseInfo res) throws Exception {
        try {
            if (!this.isUse()) {
                throw new ExpireServerConnectException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            if (res == null) {
                res = ReadHttpResponse.readResponseByHeader(this.inputStream);
            } else {
                if (out == null) {
                    out = new ByteArrayOutputStream();
                }
                ReadHttpResponse.readResponseByBody(out, res, this.inputStream);
                out = null;
            }
            return res;
        }
        catch (SocketTimeoutException se) {
            if (this.connectionInfo.isCloseSocket()) {
                this.destroy();
                throw new CloseClientException("\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u304c\u5207\u65ad\u3055\u308c\u307e\u3057\u305f");
            }
            return null;
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    public boolean isUse() {
        return this.socket != null && this.inputStream != null && this.outputStream != null;
    }

    public boolean isPassage(long time) {
        return this.lastAccess == -1L || this.lastAccess + time <= System.currentTimeMillis();
    }

    public boolean isLocal() {
        if (this.socket == null) {
            return false;
        }
        InetAddress addr = this.socket.getInetAddress();
        return "127.0.0.1".equals(addr.getHostAddress());
    }
}

