/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.maachang.proxy.engine.net.http.ConnectionInfo;
import org.maachang.proxy.engine.net.server.HttpConnector;
import org.maachang.proxy.engine.net.server.ProxyInfo;

public class HttpPoolingConnector {
    private static final int RECEIVE_TIMEOUT = 5000;
    private static final int BUFFER = 131072;
    private static final int LINGER_TIME = 15;
    private static final long CLOSE_CONNECT_TIME = 3500L;
    private ProxyInfo proxy = null;
    private List<HttpConnector> conns = null;

    private HttpPoolingConnector() {
    }

    public HttpPoolingConnector(ProxyInfo proxy) throws Exception {
        if (proxy == null || !proxy.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.proxy = proxy;
        this.conns = Collections.synchronizedList(new ArrayList());
        this.proxy.setHttpPoolingConnector(this);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.conns != null) {
            int len = this.conns.size();
            int i = 0;
            while (i < len) {
                HttpConnector con = this.conns.get(i);
                if (con != null) {
                    con.destroy();
                }
                ++i;
            }
            this.conns.clear();
        }
        this.conns = null;
        this.proxy = null;
    }

    public HttpConnector getConnector(ConnectionInfo conn) throws Exception {
        if (conn == null) {
            throw new IOException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        HttpConnector ret = this.getToRemove();
        if (ret == null) {
            ret = this.createConnector();
        }
        if (ret == null) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        ret.setConnectionInfo(conn);
        return ret;
    }

    public void releaseConnector(HttpConnector httpConnector) {
        if (httpConnector == null || !httpConnector.isUse()) {
            return;
        }
        httpConnector.setConnectionInfo(null);
        httpConnector.setLastAccess();
        this.conns.add(httpConnector);
    }

    public int getUseLength() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.conns.size();
    }

    public boolean isUse() {
        return this.proxy != null && this.proxy.isUse();
    }

    public boolean checkConnect(HttpConnector conn) {
        return conn != null && conn.isUse() && !conn.isPassage(3500L);
    }

    private HttpConnector createConnector() throws Exception {
        InetAddress addr = InetAddress.getByName(this.proxy.getDestUrl());
        Socket socket = new Socket(addr, this.proxy.getPort());
        socket.setSendBufferSize(131072);
        socket.setReceiveBufferSize(131072);
        socket.setKeepAlive(true);
        socket.setTcpNoDelay(true);
        socket.setReuseAddress(true);
        socket.setSoLinger(true, 15);
        socket.setSoTimeout(5000);
        return new HttpConnector(socket);
    }

    private HttpConnector getToRemove() {
        HttpConnector ret = null;
        do {
            if (this.conns.size() > 0) continue;
            return null;
        } while (!this.checkConnect(ret = this.conns.remove(0)));
        return ret;
    }
}

