/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.server;

import org.maachang.proxy.engine.conf.ProxyOption;
import org.maachang.proxy.engine.net.server.HttpPoolingConnector;

public class ProxyInfo {
    private String name = null;
    private String url = null;
    private String destUrl = null;
    private int port = -1;
    private boolean stopService = false;
    private boolean accessPcFlag = true;
    private boolean accessMobileFlag = true;
    private String sessionName = null;
    private String charset = null;
    private HttpPoolingConnector httpPoolingConnector = null;

    public ProxyInfo() {
    }

    public ProxyInfo(ProxyOption option) throws Exception {
        if (option == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.name = option.getName().trim().toLowerCase();
        this.url = option.getUrl();
        this.destUrl = option.getDestUrl();
        this.port = option.getPort();
        this.stopService = option.isStopService();
        this.accessPcFlag = option.isAccessPcFlag();
        this.accessMobileFlag = option.isAccessMobileFlag();
        this.sessionName = option.getSessionName();
        this.charset = option.getCharset();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    protected void destroy() {
        try {
            this.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.name = null;
        this.url = null;
        this.destUrl = null;
        this.port = -1;
        this.httpPoolingConnector = null;
        this.stopService = true;
        this.accessPcFlag = true;
        this.accessMobileFlag = true;
        this.sessionName = null;
        this.charset = null;
    }

    public void startup() throws Exception {
        this.stop();
        new HttpPoolingConnector(this);
    }

    public void stop() throws Exception {
        if (this.httpPoolingConnector != null) {
            this.httpPoolingConnector.destroy();
        }
        this.httpPoolingConnector = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null || (name = name.trim()).length() <= 0 ? null : name.trim();
    }

    public String getDestUrl() {
        return this.destUrl;
    }

    public void setDestUrl(String destUrl) {
        this.destUrl = destUrl;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isStopService() {
        return this.stopService;
    }

    public void setStopService(boolean stopService) {
        this.stopService = stopService;
    }

    public boolean isAccessMobileFlag() {
        return this.accessMobileFlag;
    }

    public void setAccessMobileFlag(boolean accessMobileFlag) {
        this.accessMobileFlag = accessMobileFlag;
    }

    public boolean isAccessPcFlag() {
        return this.accessPcFlag;
    }

    public void setAccessPcFlag(boolean accessPcFlag) {
        this.accessPcFlag = accessPcFlag;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getCharset() {
        if (this.charset == null || (this.charset = this.charset.trim()).length() <= 0) {
            return "UTF8";
        }
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public HttpPoolingConnector getHttpPoolingConnector() {
        return this.httpPoolingConnector;
    }

    public void setHttpPoolingConnector(HttpPoolingConnector httpPoolingConnector) {
        this.httpPoolingConnector = httpPoolingConnector;
    }

    public boolean isUse() {
        return this.name != null && this.url != null && this.destUrl != null && this.port > 0;
    }

    public ProxyOption getOption() {
        ProxyOption ret = new ProxyOption();
        ret.setDestUrl(this.destUrl);
        ret.setName(this.name);
        ret.setPort(this.port);
        ret.setUrl(this.url);
        ret.setStopService(this.stopService);
        ret.setAccessPcFlag(this.accessPcFlag);
        ret.setAccessMobileFlag(this.accessMobileFlag);
        ret.setSessionName(this.sessionName);
        ret.setCharset(this.charset);
        return ret;
    }
}

