/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.maachang.proxy.engine.conf.ProxyOption;
import org.maachang.proxy.engine.conf.ProxyOptions;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.server.ProxyInfo;

public class ProxyManager {
    private List<ProxyInfo> man = Collections.synchronizedList(new ArrayList());

    public ProxyManager() {
    }

    public ProxyManager(ProxyOptions options) throws Exception {
        this();
        try {
            if (options == null || options.size() <= 0) {
                return;
            }
            int len = options.size();
            int i = 0;
            while (i < len) {
                ProxyOption opt = options.get(i);
                this.add(opt);
                ++i;
            }
        }
        catch (Exception e) {
            this.man = null;
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.clear();
        this.man = null;
    }

    public void clear() {
        if (this.man != null) {
            int len = this.man.size();
            int i = 0;
            while (i < len) {
                this.man.get(i).destroy();
                ++i;
            }
            this.man.clear();
        }
    }

    public void add(ProxyOption option) throws Exception {
        this.add(new ProxyInfo(option));
    }

    public void add(ProxyInfo proxy) throws Exception {
        if (proxy == null || !proxy.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.isURL(proxy.getUrl())) {
            throw new IllegalArgumentException("\u65e2\u306b\u540c\u3058URL(" + proxy.getName() + "\u304c\u5b58\u5728\u3057\u307e\u3059");
        }
        if (this.isName(proxy.getName())) {
            throw new IllegalArgumentException("\u65e2\u306b\u540c\u3058\u540d\u524d(" + proxy.getName() + "\u304c\u5b58\u5728\u3057\u307e\u3059");
        }
        this.man.add(proxy);
        proxy.startup();
    }

    public ProxyInfo remove(int no) {
        if (no < 0 || no >= this.man.size()) {
            return null;
        }
        return this.man.remove(no);
    }

    public ProxyInfo remove(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        int no = this.searchName(name);
        if (no >= 0) {
            return this.man.remove(no);
        }
        return null;
    }

    public ProxyInfo get(int no) {
        if (no < 0 || no >= this.man.size()) {
            return null;
        }
        return this.man.get(no);
    }

    public ProxyInfo get(RequestInfo request) {
        if (request == null) {
            return null;
        }
        int no = this.searchURL(request.getHeader("Host", 0));
        if (no >= 0) {
            return this.man.get(no);
        }
        return null;
    }

    public int size() {
        return this.man.size();
    }

    public boolean isUse() {
        return this.man != null;
    }

    public ProxyOptions convertProxyOptions() {
        if (this.man == null || this.man.size() <= 0) {
            return new ProxyOptions();
        }
        int len = this.man.size();
        ProxyOptions ret = new ProxyOptions(len);
        int i = 0;
        while (i < len) {
            ret.set(this.man.get(i).getOption(), i);
            ++i;
        }
        return ret;
    }

    public boolean isName(String name) {
        return this.searchName(name) != -1;
    }

    public boolean isURL(String name) {
        return this.searchURL(name) != -1;
    }

    private int searchName(String string) {
        if (string == null || (string = string.trim()).length() <= 0) {
            return -1;
        }
        string = string.trim().toLowerCase();
        int len = this.man.size();
        int i = 0;
        while (i < len) {
            ProxyInfo px = this.man.get(i);
            if (string.equals(px.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int searchURL(String string) {
        if (string == null || (string = string.trim()).length() <= 0) {
            return -1;
        }
        int len = this.man.size();
        int i = 0;
        while (i < len) {
            ProxyInfo px = this.man.get(i);
            if (string.equals(px.getUrl())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

