/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import org.maachang.proxy.engine.net.ResponseInfo;
import org.maachang.proxy.engine.net.server.ExpireServerConnectException;
import org.maachang.util.AnalysisUtil;
import org.maachang.util.ArrayBinary;
import org.maachang.util.StringUtil;

public class ReadHttpResponse {
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String CHUNKED = "chunked";
    private static final String CHARSET = "UTF8";
    private static final byte[] ENTER = new byte[]{13, 10};
    private static final byte[] END_HEADER = new byte[]{13, 10, 13, 10};

    private ReadHttpResponse() {
    }

    public static final ResponseInfo readResponseByHeader(InputStream stream) throws Exception {
        try {
            int endPoint = 0;
            int endHeaderLen = END_HEADER.length;
            ArrayBinary buf = new ArrayBinary();
            while (true) {
                int d;
                if ((d = stream.read()) <= -1) {
                    if (buf.length() <= 0) {
                        return null;
                    }
                    return ReadHttpResponse.convertHttpdHeader(buf.getRawBinary(), buf.length());
                }
                buf.write(d &= 0xFF);
                if (d == (END_HEADER[endPoint] & 0xFF)) {
                    if (++endPoint < endHeaderLen) continue;
                    if (buf.length() <= 0) {
                        return null;
                    }
                    return ReadHttpResponse.convertHttpdHeader(buf.getRawBinary(), buf.length());
                }
                endPoint = 0;
            }
        }
        catch (SocketException se) {
            throw new ExpireServerConnectException("\u30d8\u30c3\u30c0\u53d7\u4fe1\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
    }

    public static final void readResponseByBody(OutputStream out, ResponseInfo res, InputStream stream) throws Exception {
        String s;
        boolean rawMode = true;
        if (out instanceof ByteArrayOutputStream) {
            rawMode = false;
        }
        if (res.headerSize(TRANSFER_ENCODING) == 1) {
            s = res.getHeader(TRANSFER_ENCODING, 0);
            if (!CHUNKED.equals(s)) {
                throw new IOException("\u4e0d\u6b63\u306a[Transfer-Encoding=" + s + "]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            if (rawMode) {
                ReadHttpResponse.readBodyByChunkedToRaw(out, stream);
            } else {
                ReadHttpResponse.readBodyByChunked(out, stream);
            }
        } else if (res.headerSize(CONTENT_LENGTH) == 1) {
            s = res.getHeader(CONTENT_LENGTH, 0);
            if (s == null || s.length() <= 0) {
                throw new IOException("\u4e0d\u6b63\u306a[Content-Length]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            int contentLength = Integer.parseInt(s);
            if (contentLength <= -1) {
                throw new IOException("\u53d7\u4fe1\u30c7\u30fc\u30bf\u9577[" + contentLength + "]\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (contentLength == 0) {
                return;
            }
            ReadHttpResponse.readBodyByLength(out, contentLength, stream);
        } else {
            ReadHttpResponse.readBodyByNoSetting(out, stream);
        }
        if (!rawMode) {
            byte[] b = ((ByteArrayOutputStream)out).toByteArray();
            res.setBody(b);
            out.close();
            out = null;
        }
    }

    private static final void readBodyByChunked(OutputStream out, InputStream stream) throws Exception {
        int len = -1;
        int enterPos = 0;
        int pos = 0;
        int cnt = 0;
        byte[] buf = new byte[32];
        while (true) {
            int d;
            if ((d = stream.read()) <= -1) {
                throw new IOException("\u4e0d\u6b63\u306achunked\u7d42\u7aef\u3092\u691c\u51fa\u3057\u307e\u3057\u305f(" + len + ")");
            }
            d &= 0xFF;
            ++cnt;
            if (len == -1) {
                if (d == (ENTER[enterPos] & 0xFF)) {
                    if (++enterPos < ENTER.length) continue;
                    if (pos > 0) {
                        String chLen = new String(buf, 0, pos, CHARSET);
                        len = ReadHttpResponse.convertChunkedDataLength(chLen);
                        if (len == 0) {
                            int exitCnt = 0;
                            while (true) {
                                if (stream.available() <= 0) {
                                    continue;
                                }
                                stream.read();
                                if (++exitCnt >= ENTER.length) break;
                            }
                            return;
                        }
                        pos = 0;
                        enterPos = 0;
                        continue;
                    }
                    enterPos = 0;
                    continue;
                }
                if (enterPos >= 1) {
                    throw new IOException("\u4e0d\u6b63\u306achunked\u30c7\u30fc\u30bf\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                }
                buf[pos] = (byte)d;
                ++pos;
                continue;
            }
            out.write(d);
            if (len > ++pos) continue;
            len = -1;
            pos = 0;
            enterPos = 0;
        }
    }

    private static final void readBodyByChunkedToRaw(OutputStream out, InputStream stream) throws Exception {
        int len = -1;
        int enterPos = 0;
        int pos = 0;
        int cnt = 0;
        byte[] buf = new byte[32];
        while (true) {
            int d;
            if ((d = stream.read()) <= -1) {
                throw new IOException("\u4e0d\u6b63\u306achunked\u7d42\u7aef\u3092\u691c\u51fa\u3057\u307e\u3057\u305f(" + len + ")");
            }
            ++cnt;
            out.write(d &= 0xFF);
            if (len == -1) {
                if (d == (ENTER[enterPos] & 0xFF)) {
                    if (++enterPos < ENTER.length) continue;
                    if (pos > 0) {
                        String chLen = new String(buf, 0, pos, CHARSET);
                        len = ReadHttpResponse.convertChunkedDataLength(chLen);
                        if (len == 0) {
                            int exitCnt = 0;
                            while (true) {
                                if (stream.available() <= 0) {
                                    continue;
                                }
                                d = stream.read();
                                out.write(d &= 0xFF);
                                if (++exitCnt >= ENTER.length) break;
                            }
                            return;
                        }
                        pos = 0;
                        enterPos = 0;
                        continue;
                    }
                    enterPos = 0;
                    continue;
                }
                if (enterPos >= 1) {
                    throw new IOException("\u4e0d\u6b63\u306achunked\u30c7\u30fc\u30bf\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                }
                buf[pos] = (byte)d;
                ++pos;
                continue;
            }
            if (len > ++pos) continue;
            len = -1;
            pos = 0;
            enterPos = 0;
        }
    }

    private static final void readBodyByLength(OutputStream out, int contentLength, InputStream stream) throws Exception {
        int pnt = 0;
        do {
            int d;
            if ((d = stream.read()) <= -1) {
                return;
            }
            out.write(d);
        } while (contentLength > ++pnt);
    }

    private static final void readBodyByNoSetting(OutputStream out, InputStream stream) throws Exception {
        int pnt = 0;
        int d;
        while ((d = stream.read()) > -1) {
            out.write(d);
            ++pnt;
        }
        return;
    }

    private static final int convertChunkedDataLength(String s) throws Exception {
        try {
            return Integer.parseInt(s, 16);
        }
        catch (Exception e) {
            if (s == null || s.length() <= 0) {
                throw new IOException("\u4e0d\u6b63\u306achunked\u30d8\u30c3\u30c0\u6570\u5024\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            }
            throw new IOException("\u4e0d\u6b63\u306achunked\u30d8\u30c3\u30c0\u6570\u5024[" + AnalysisUtil.toStringByBinary(s.getBytes()) + "-(" + s + ")]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
        }
    }

    private static int binaryIndexOf(byte[] binary, byte[] data, int off, int len) throws Exception {
        if (binary == null || binary.length <= 0 || data == null || data.length <= 0) {
            return -1;
        }
        int dataLen = data.length;
        if (len <= 0 || len >= binary.length) {
            len = binary.length;
        }
        int ret = -1;
        int i = off;
        while (i < len) {
            if (binary[i] == data[0] && i + dataLen <= len) {
                ret = i;
                int j = 1;
                while (j < dataLen) {
                    if (binary[i + j] != data[j]) {
                        ret = -1;
                        break;
                    }
                    ++j;
                }
                if (ret != -1) {
                    return ret;
                }
            }
            ++i;
        }
        return -1;
    }

    private static final ResponseInfo convertHttpdHeader(byte[] binary, int endPos) throws Exception {
        ResponseInfo ret = new ResponseInfo();
        int p = 0;
        int b = 0;
        int line = 0;
        int enterLen = ENTER.length;
        while (true) {
            if ((p = ReadHttpResponse.binaryIndexOf(binary, ENTER, b, endPos)) == -1) {
                if (b >= endPos) break;
                p = endPos;
            }
            String one = new String(binary, b, p - b, CHARSET);
            b = p + enterLen;
            if (line == 0) {
                ReadHttpResponse.convertResultStateAndVersion(ret, one);
            } else {
                ReadHttpResponse.convertHttpHeader(ret, one);
            }
            if (p >= endPos) break;
            ++line;
        }
        return ret;
    }

    private static final void convertResultStateAndVersion(ResponseInfo out, String oneLine) {
        int pos1 = oneLine.indexOf(" ");
        int pos2 = oneLine.indexOf(" ", pos1 + 1);
        String version = oneLine.substring(0, pos1);
        String state = oneLine.substring(pos1 + 1, pos2);
        String stateMessage = oneLine.substring(pos2 + 1, oneLine.length());
        out.setVersion(version.trim());
        out.setState(state.trim());
        out.setStateMessage(stateMessage.trim());
    }

    private static final void convertHttpHeader(ResponseInfo out, String oneLine) {
        int p = oneLine.indexOf(":");
        if (p == -1) {
            return;
        }
        String key = oneLine.substring(0, p).trim();
        if ((oneLine = oneLine.substring(++p + 1, oneLine.length())) == null || (oneLine = oneLine.trim()).length() <= 0) {
            out.addHeader(key, null);
        } else if (key.indexOf("User-Agent") != -1 || key.indexOf("Modified") != -1 || key.indexOf("Date") != -1) {
            out.putHeader(key, oneLine);
        } else if (oneLine.indexOf(",") != -1) {
            ArrayList<String> lst = StringUtil.cutString(oneLine, ",");
            int len = lst.size();
            int i = 0;
            while (i < len) {
                String o;
                if (i == 0) {
                    o = lst.get(i).trim();
                    if (o.length() > 0) {
                        int sp = o.indexOf(" ");
                        if (sp != -1) {
                            boolean flg = false;
                            int j = 0;
                            while (j < sp) {
                                char c = o.charAt(j);
                                if (c == '\"' || c == '\'') {
                                    flg = true;
                                    break;
                                }
                                ++j;
                            }
                            if (flg) {
                                out.addHeader(key, o);
                            } else {
                                out.addHeader(key, o.substring(0, sp).trim());
                                out.addHeader(key, o.substring(sp + 1).trim());
                            }
                        } else {
                            out.addHeader(key, o);
                        }
                    }
                } else {
                    o = lst.get(i).trim();
                    if (o.length() > 0) {
                        out.addHeader(key, o);
                    }
                }
                ++i;
            }
        } else if ((oneLine = oneLine.trim()).length() > 0) {
            out.addHeader(key, oneLine);
        }
    }
}

