/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.net.URLEncoder;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.http.HttpParams;
import org.maachang.util.HttpdUtil;

public class AnalysisUtil {
    private static final String DEF_CHARSET = "UTF8";
    private static final char[] SJIS_MS932_MAP = new char[]{'\u301c', '\uff5e', '\u2016', '\u2225', '\u2212', '\uff0d', '\u00a2', '\uffe0', '\u00a3', '\uffe1', '\u00ac', '\uffe2'};

    public static int binaryIndexOf(byte[] binary, String data, int off) throws Exception {
        return AnalysisUtil.binaryIndexOf(binary, data, DEF_CHARSET, off, binary.length);
    }

    public static int binaryIndexOf(byte[] binary, String data, int off, int len) throws Exception {
        return AnalysisUtil.binaryIndexOf(binary, data, DEF_CHARSET, off, len);
    }

    public static int binaryIndexOf(byte[] binary, String data, String charset, int off) throws Exception {
        return AnalysisUtil.binaryIndexOf(binary, data, charset, off, binary.length);
    }

    public static int binaryIndexOf(byte[] binary, String data, String charset, int off, int len) throws Exception {
        if (binary == null || binary.length <= 0 || data == null || data.length() <= 0) {
            return -1;
        }
        return AnalysisUtil.binaryIndexOf(binary, data.getBytes(charset), off, len);
    }

    public static int binaryIndexOf(byte[] binary, byte[] data, int off) throws Exception {
        return AnalysisUtil.binaryIndexOf(binary, data, off, binary.length);
    }

    public static int binaryIndexOf(byte[] binary, byte[] data, int off, int len) throws Exception {
        if (binary == null || binary.length <= 0 || data == null || data.length <= 0) {
            return -1;
        }
        int dataLen = data.length;
        if (len <= 0 || len >= binary.length) {
            len = binary.length;
        }
        int ret = -1;
        int i = off;
        while (i < len) {
            if (binary[i] == data[0] && i + dataLen <= len) {
                ret = i;
                int j = 1;
                while (j < dataLen) {
                    if (binary[i + j] != data[j]) {
                        ret = -1;
                        break;
                    }
                    ++j;
                }
                if (ret != -1) {
                    return ret;
                }
            }
            ++i;
        }
        return -1;
    }

    public static final HttpParams convertRequestParams(RequestInfo request) throws Exception {
        return AnalysisUtil.convertRequestParams(request, DEF_CHARSET);
    }

    public static final HttpParams convertRequestParams(RequestInfo request, String charset) throws Exception {
        HttpParams ret = new HttpParams();
        AnalysisUtil.convertAnalysisQuery(ret, request, charset);
        AnalysisUtil.convertAnalysisBody(ret, request, charset);
        return ret;
    }

    public static final HttpParams convertAnalysisQuery(RequestInfo request) throws Exception {
        return AnalysisUtil.convertAnalysisQuery(request, DEF_CHARSET);
    }

    public static final HttpParams convertAnalysisQuery(RequestInfo request, String charset) throws Exception {
        HttpParams ret = new HttpParams();
        AnalysisUtil.convertAnalysisQuery(ret, request, charset);
        return ret;
    }

    public static final void convertAnalysisQuery(HttpParams out, RequestInfo request) throws Exception {
        AnalysisUtil.convertAnalysisQuery(out, request, DEF_CHARSET);
    }

    public static final void convertAnalysisQuery(HttpParams out, RequestInfo request, String charset) throws Exception {
        String query = HttpdUtil.getQueryValue(request.getUrl());
        if (query != null && (query = query.trim()).length() > 0) {
            HttpdUtil.convertQueryByParams(out, query, charset);
        }
    }

    public static final HttpParams convertAnalysisBody(RequestInfo request) throws Exception {
        return AnalysisUtil.convertAnalysisBody(request, DEF_CHARSET);
    }

    public static final HttpParams convertAnalysisBody(RequestInfo request, String charset) throws Exception {
        HttpParams ret = new HttpParams();
        AnalysisUtil.convertAnalysisBody(ret, request, charset);
        return ret;
    }

    public static final void convertAnalysisBody(HttpParams out, RequestInfo request) throws Exception {
        AnalysisUtil.convertAnalysisBody(out, request, DEF_CHARSET);
    }

    public static final void convertAnalysisBody(HttpParams out, RequestInfo request, String charset) throws Exception {
        String body;
        if (request.getBody() != null && request.getBody().length > 0 && (body = new String(request.getBody(), "ISO-8859-1")) != null && (body = body.trim()).length() > 0) {
            HttpdUtil.convertQueryByParams(out, body, charset);
        }
    }

    public static final String convertBodyByCharset(String body, String srcCharset, String destCharset) throws Exception {
        if (body == null || (body = body.trim()).length() <= 0) {
            return null;
        }
        HttpParams params = new HttpParams();
        HttpdUtil.convertQueryByParams(params, body, srcCharset);
        StringBuilder buf = new StringBuilder();
        String[] keys = params.getKeys();
        if (keys != null) {
            int len = keys.length;
            int cnt = 0;
            int i = 0;
            while (i < len) {
                if (cnt != 0) {
                    buf.append("&");
                }
                int lenJ = params.size(keys[i]);
                int j = 0;
                while (j < lenJ) {
                    String v;
                    if (cnt != 0) {
                        buf.append("&");
                    }
                    if ((v = (String)params.get(keys[i], j)) == null || (v = v.trim()).length() <= 0) {
                        buf.append(keys[i]).append("=");
                    } else {
                        buf.append(keys[i]).append("=").append(URLEncoder.encode(v, destCharset));
                    }
                    ++cnt;
                    ++j;
                }
                ++i;
            }
            return buf.toString();
        }
        return null;
    }

    public static final int convertInt(String code) {
        int ret = -1;
        try {
            ret = Integer.parseInt(code);
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public static String cutGetParam(String url) {
        int x = url.indexOf("?");
        if (x <= 0) {
            return url;
        }
        return url.substring(0, x);
    }

    public static final char toMS932(char c) {
        int len = SJIS_MS932_MAP.length;
        int i = 0;
        while (i < len) {
            if (c == SJIS_MS932_MAP[i]) {
                c = SJIS_MS932_MAP[i + 1];
                break;
            }
            i += 2;
        }
        return c;
    }

    public static final char toSJIS(char c) {
        int len = SJIS_MS932_MAP.length;
        int i = 0;
        while (i < len) {
            if (c == SJIS_MS932_MAP[i + 1]) {
                c = SJIS_MS932_MAP[i];
                break;
            }
            i += 2;
        }
        return c;
    }

    public static final String toMS932(String str) {
        if (str == null) {
            return null;
        }
        char[] c = new char[str.length()];
        int len = str.length();
        int i = 0;
        while (i < len) {
            c[i] = AnalysisUtil.toMS932(str.charAt(i));
            ++i;
        }
        return new String(c);
    }

    public static final String toSJIS(String str) {
        if (str == null) {
            return null;
        }
        char[] c = new char[str.length()];
        int len = str.length();
        int i = 0;
        while (i < len) {
            c[i] = AnalysisUtil.toSJIS(str.charAt(i));
            ++i;
        }
        return new String(c);
    }

    public static final String toStringByBinary(byte[] bin) {
        if (bin == null || bin.length <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int len = bin.length;
        int i = 0;
        while (i < len) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append("0x").append(Integer.toHexString(bin[i] & 0xFF));
            ++i;
        }
        return buf.toString();
    }
}

