/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerPrint {
    private static final Log LOG = LogFactory.getLog(TimerPrint.class);
    private long time = -1L;
    private long wait = -1L;

    public String start() {
        String ret = this.toString();
        this.time = System.currentTimeMillis();
        this.wait = -1L;
        return ret;
    }

    public long stop() {
        if (this.time <= -1L) {
            this.wait = -1L;
            return -1L;
        }
        this.wait = System.currentTimeMillis() - this.time;
        return this.wait;
    }

    public long get() {
        return this.wait;
    }

    public String toString() {
        if (this.wait <= -1L) {
            return " not wait";
        }
        return "- {{" + this.wait + "}}ms";
    }

    public void println(String string) {
        if (string == null) {
            System.out.println(this.toString());
        } else {
            System.out.println(String.valueOf(string) + this.toString());
        }
    }

    public void debug(String string) {
        if (LOG.isDebugEnabled()) {
            if (string == null) {
                LOG.debug((Object)this.toString());
            } else {
                LOG.debug((Object)(String.valueOf(string) + this.toString()));
            }
        }
    }
}

