package org.maachang.proxy;

import org.maachang.proxy.down.SendShutdown;

/**
 * MDbmServerシャットダウン処理.
 * 
 * @version 2008/03/25
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class ShutdownMaachangProxy {
    
    /**
     * １回のシャットダウン待ち.
     */
    private static final int TIMEOUT = 5000 ;
    
    /**
     * シャットダウンリトライ数.
     */
    private static final int RETRY = 12 ;
    
    private ShutdownMaachangProxy() {
        
    }
    
    /**
     * メインメソッド.
     * <BR><BR>
     * @param args Javaからのパラメータが設定されます.
     * @exception Exception 例外.
     */
    public static final void main( String[] args )
        throws Exception {
        new ShutdownMaachangProxy().execution( args ) ;
    }
    
    /**
     * 実行処理.
     */
    private void execution( String[] args )
        throws Exception {
        int port = MaachangProxy.getShutdownPort( null ) ;
        if( args != null || args.length >= 1 ) {
            int argsPort = -1 ;
            try {
                argsPort = Integer.parseInt( args[ 0 ] ) ;
            } catch( Exception e ) {
                argsPort = -1 ;
            }
            if( argsPort > 0 && argsPort <= 65535 ) {
                port = argsPort ;
            }
        }
        System.out.println( "# シャットダウン処理を実施:" + port  ) ;
        int exitCode = 0 ;
        boolean retry = false ;
        try {
            for( int i = 0 ; i < RETRY ; i ++ ) {
                if( new SendShutdown().send( port,TIMEOUT ) == true ) {
                    System.out.println( "# シャットダウン処理終了" ) ;
                    retry = true ;
                    break ;
                }
            }
            if( retry == false ) {
                System.out.println( "# シャットダウン終了通知がありません" ) ;
                exitCode = -1 ;
            }
        } catch( Exception e ) {
            System.out.println( "# シャットダウン処理でエラー" ) ;
            exitCode = -1 ;
            e.printStackTrace() ;
        }
        System.exit( exitCode ) ;
    }
    
}

