package org.maachang.proxy.down;

/**
 * シャットダウンフック.
 *
 * @version 2008/03/25
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class ShutdownHook extends Thread {
    /**
     * シャットダウンコールバックメソッド.
     */
    private ShutdownCallback callback = null ;
    
    /**
     * コンストラクタ.
     */
    private ShutdownHook() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * シャットダウンフックを設定してオブジェクトを生成します.
     * <BR>
     * @param callback シャットダウンコールバックオブジェクトを設定します.
     */
    private ShutdownHook( ShutdownCallback callback ) {
        this.callback = callback ;
        this.setPriority( Thread.MAX_PRIORITY ) ;
        this.setDaemon( false ) ;
    }
    
    /**
     * シャットダウンフックの開始.
     * <BR><BR>
     * シャットダウンフックを開始します.
     * <BR>
     * @param callback シャットダウンコールバックオブジェクトを設定します.
     * @return ShutdownHook 生成されたシャットダウンフックオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final ShutdownHook registHook( ShutdownCallback callback )
        throws Exception {
        if( callback == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        ShutdownHook ret = new ShutdownHook( callback ) ;
        Runtime.getRuntime().addShutdownHook( ret ) ;
        return ret ;
    }
    
    /**
     * シャットダウンコールバックオブジェクトを取得.
     * <BR>
     * @return ShutdownCallback シャットダウンコールバックオブジェクトが返されます.
     */
    public ShutdownCallback getShutdownCallback() {
        return callback ;
    }
    
    /**
     * シャットダウン実行.
     * <BR><BR>
     * シャットダウン処理を実施します.
     */
    public void run() {
        if( callback.isShutdown() == false ) {
            callback.execution() ;
        }
    }
}
