package org.maachang.proxy.engine;

/**
 * エラーステータス例外.
 * 
 * @version 2007/08/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class ErrorStateException extends StateException {
    private static final long serialVersionUID = 1100366215581214086L;
    
    /**
     * コンストラクタ.
     */
    public ErrorStateException() {
        super() ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * HTTPステータスを設定して、オブジェクトを生成.
     * <BR>
     * @param host 対象のホスト名を設定します.
     */
    public ErrorStateException( String host ) {
        super( host ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * HTTPステータスを設定して、オブジェクトを生成.
     * <BR>
     * @param host 対象のホスト名を設定します.
     * @param state 対象のHTTPステータスを設定します.
     */
    public ErrorStateException( String host,int state ) {
        super( host,state ) ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * HTTPステータスを設定して、オブジェクトを生成.
     * <BR>
     * @param host 対象のホスト名を設定します.
     * @param state 対象のHTTPステータスを設定します.
     * @param errorMessage 対象のエラーメッセージを設定します.
     */
    public ErrorStateException( String host,int state,String errorMessage ) {
        super( host,state,errorMessage ) ;
    }
}
