package org.maachang.proxy.engine;

/**
 * 受信データ解析対象拡張子.
 * 
 * @version 2007/08/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class ReceiveAnalysisDefine {
    
    /**
     * 解析対象Mimeタイプ.
     */
    private static final String[] PLUS_NAMES = {
        "text/plain","text/html","application/xhtml+xml",
        "image/x-bmp","image/gif","image/jpeg","image/x-png" } ;
    
    /**
     * コンテンツタイプを指定して、データ解析を行うMimeタイプかチェック.
     * @param value 対象のコンテンツタイプ要素を設定します.
     * @return boolean [true]の場合、解析対象のコンテンツタイプ要素です.
     */
    public static final boolean isAnalysis( String value ) {
        if( value == null || ( value = value.trim() ).length() <= 0 ) {
            return false ;
        }
        int len = PLUS_NAMES.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            if( value.startsWith( PLUS_NAMES[ i ] ) ) {
                return true ;
            }
        }
        return false ;
    }
    
}
