package org.maachang.proxy.engine;

import org.maachang.proxy.engine.error.ErrorDef;


/**
 * ステータス例外.
 * 
 * @version 2007/08/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class StateException extends Exception {
    private static final long serialVersionUID = 7811112240652062571L;
    
    /**
     * 例外Host名.
     */
    protected String host = null ;
    
    /**
     * 例外ステータス.
     */
    protected int state = -1 ;
    
    /**
     * エラーメッセージ.
     */
    protected String errorMessage = null ;
    
    /**
     * コンストラクタ.
     */
    public StateException() {
        super() ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * HTTPステータスを設定して、オブジェクトを生成.
     * <BR>
     * @param host 対象のホスト名を設定します.
     */
    public StateException( String host ) {
        super() ;
        this.host = host ;
        this.state = ErrorDef.HTTP11_500 ;
        this.errorMessage = null ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * HTTPステータスを設定して、オブジェクトを生成.
     * <BR>
     * @param host 対象のホスト名を設定します.
     * @param state 対象のHTTPステータスを設定します.
     */
    public StateException( String host,int state ) {
        super() ;
        this.host = host ;
        this.state = state ;
        this.errorMessage = null ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * HTTPステータスを設定して、オブジェクトを生成.
     * <BR>
     * @param host 対象のホスト名を設定します.
     * @param state 対象のHTTPステータスを設定します.
     * @param errorMessage 対象のエラーメッセージを設定します.
     */
    public StateException( String host,int state,String errorMessage ) {
        super() ;
        this.host = host ;
        this.state = state ;
        this.errorMessage = errorMessage ;
    }
    
    /**
     * HTTPステータスを取得.
     * <BR><BR>
     * HTTPステータスを取得します.
     * <BR>
     * @return int HTTPステータスが返されます.
     */
    public int getState() {
        return this.state ;
    }
    
    /**
     * エラーメッセージを取得.
     * <BR><BR>
     * エラーメッセージを取得します.
     * <BR>
     * @return String エラーメッセージが返されます.
     */
    public String getErrorMessage() {
        return this.errorMessage ;
    }
    
    /**
     * ホスト名を取得.
     * <BR><BR>
     * ホスト名が返されます.
     * <BR>
     * @return String ホスト名が返されます.
     */
    public String getHost() {
        return this.host ;
    }
}
