package org.maachang.proxy.engine.admin ;


/**
 * MaachangProxyログイン後処理用.
 * 
 * @version 2008/03/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public abstract class AbstractAdminNextLogin extends AbstractAdminPage {
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AbstractAdminNextLogin( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void execution( AdminConnect conn )
        throws Exception {
        if( isLogin( conn ) == false ) {
            nextLogin( conn ) ;
        }
    }
    
    /**
     * ログイン処理後の実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void nextLogin( AdminConnect conn )
        throws Exception {
    }
}
