package org.maachang.proxy.engine.admin ;

import java.util.HashMap;

import org.maachang.proxy.engine.conf.AccessManager;
import org.maachang.proxy.engine.conf.MaachangProxyConfig;
import org.maachang.proxy.engine.conf.RefusalAddressManager;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.ResponseInfo;
import org.maachang.proxy.engine.net.http.HttpParams;
import org.maachang.proxy.engine.net.server.ProxyManager;

public class AdminConnect {
    private boolean forwardFlag = false ;
    private ResponseInfo response = null ;
    private MaachangProxyConfig conf = null ;
    private ProxyManager proxyManager = null ;
    private AccessManager accessManager = null ;
    private RefusalAddressManager refusal = null ;
    private AdminManager manager = null ;
    private AdminSession session = null ;
    private RequestInfo request = null ;
    private HttpParams params = null ;
    private long seqId = -1L ;
    private HashMap<String,String> viewParams = null ;
    
    private AdminConnect() {
        
    }
    
    public AdminConnect( ResponseInfo response,
        MaachangProxyConfig conf,ProxyManager proxyManager,
        RefusalAddressManager refusal,AccessManager accessManager,
        AdminManager manager,AdminSession session,
        RequestInfo request,HttpParams params,long seqId,
        HashMap<String,String> viewParams ) {
        this.response = response ;
        this.conf = conf ;
        this.proxyManager = proxyManager ;
        this.refusal = refusal ;
        this.accessManager = accessManager ;
        this.manager = manager ;
        this.session = session ;
        this.request = request ;
        this.params = params ;
        this.viewParams = viewParams ;
    }

    /**
     * accessManager を取得.
     * <BR><BR>
     * @return conf が返されます.
     */
    public AccessManager getAccessManager() {
        return accessManager;
    }

    /**
     * conf を取得.
     * <BR><BR>
     * @return conf が返されます.
     */
    public MaachangProxyConfig getConf() {
        return conf;
    }

    /**
     * conf を設定.
     * <BR><BR>
     * @param conf conf を設定します.
     */
    public void setConf(MaachangProxyConfig conf) {
        this.conf = conf;
    }

    /**
     * manager を取得.
     * <BR><BR>
     * @return manager が返されます.
     */
    public AdminManager getManager() {
        return manager;
    }

    /**
     * manager を設定.
     * <BR><BR>
     * @param manager manager を設定します.
     */
    public void setManager(AdminManager manager) {
        this.manager = manager;
    }

    /**
     * params を取得.
     * <BR><BR>
     * @return params が返されます.
     */
    public HttpParams getParams() {
        return params;
    }

    /**
     * params を設定.
     * <BR><BR>
     * @param params params を設定します.
     */
    public void setParams(HttpParams params) {
        this.params = params;
    }

    /**
     * proxyManager を取得.
     * <BR><BR>
     * @return proxyManager が返されます.
     */
    public ProxyManager getProxyManager() {
        return proxyManager;
    }

    /**
     * proxyManager を設定.
     * <BR><BR>
     * @param proxyManager proxyManager を設定します.
     */
    public void setProxyManager(ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    /**
     * refusal を取得.
     * <BR><BR>
     * @return refusal が返されます.
     */
    public RefusalAddressManager getRefusal() {
        return refusal;
    }

    /**
     * refusal を設定.
     * <BR><BR>
     * @param refusal refusal を設定します.
     */
    public void setRefusal(RefusalAddressManager refusal) {
        this.refusal = refusal;
    }

    /**
     * request を取得.
     * <BR><BR>
     * @return request が返されます.
     */
    public RequestInfo getRequest() {
        return request;
    }

    /**
     * request を設定.
     * <BR><BR>
     * @param request request を設定します.
     */
    public void setRequest(RequestInfo request) {
        this.request = request;
    }

    /**
     * response を取得.
     * <BR><BR>
     * @return response が返されます.
     */
    public ResponseInfo getResponse() {
        return response;
    }

    /**
     * response を設定.
     * <BR><BR>
     * @param response response を設定します.
     */
    public void setResponse(ResponseInfo response) {
        this.response = response;
    }

    /**
     * seqId を取得.
     * <BR><BR>
     * @return seqId が返されます.
     */
    public long getSeqId() {
        return seqId;
    }

    /**
     * seqId を設定.
     * <BR><BR>
     * @param seqId seqId を設定します.
     */
    public void setSeqId(long seqId) {
        this.seqId = seqId;
    }

    /**
     * session を取得.
     * <BR><BR>
     * @return session が返されます.
     */
    public AdminSession getSession() {
        return session;
    }

    /**
     * session を設定.
     * <BR><BR>
     * @param session session を設定します.
     */
    public void setSession(AdminSession session) {
        this.session = session;
    }

    /**
     * viewParams を取得.
     * <BR><BR>
     * @return viewParams が返されます.
     */
    public HashMap<String, String> getViewParams() {
        return viewParams;
    }

    /**
     * viewParams を設定.
     * <BR><BR>
     * @param viewParams viewParams を設定します.
     */
    public void setViewParams(HashMap<String, String> viewParams) {
        this.viewParams = viewParams;
    }

    /**
     * forwardFlag を取得.
     * <BR><BR>
     * @return forwardFlag が返されます.
     */
    public boolean isForwardFlag() {
        return forwardFlag;
    }

    /**
     * forwardFlag を設定.
     * <BR><BR>
     * @param forwardFlag forwardFlag を設定します.
     */
    public void setForwardFlag(boolean forwardFlag) {
        this.forwardFlag = forwardFlag;
    }
}
