package org.maachang.proxy.engine.admin.page ;

import java.util.ArrayList;
import java.util.HashMap;

import org.maachang.proxy.engine.admin.AbstractAdminNextLogin;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.conf.AccessInfo;

/**
 * アクセス履歴リスト.
 * 
 * @version 2008/04/10
 * @author masahito suzuki
 * @since MaachangProxy 1.01
 */
public class AdminAccessList extends AbstractAdminNextLogin {
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AdminAccessList( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void nextLogin( AdminConnect conn )
        throws Exception {
        ArrayList<AccessInfo> lst = conn.getAccessManager().get() ;
        HashMap<String,String> viewParams = conn.getViewParams() ;
        viewParams.put( "viewCount",String.valueOf( lst.size() ) ) ;
        viewParams.put( "viewList",viewAccessList( lst ) ) ;
    }
    
    /**
     * アクセスリストを表示.
     */
    private String viewAccessList( ArrayList<AccessInfo> lst )
        throws Exception {
        StringBuilder buf = new StringBuilder() ;
        buf.append( "<tr><th>項番</th>" ) ;
        buf.append( "<th>日付</th>" ) ;
        buf.append( "<th>state</th>" ) ;
        buf.append( "<th>URL</th>" ) ;
        buf.append( "<th>address</th>" ) ;
        buf.append( "<th>ユーザエージェント</th>" ) ;
        buf.append( "</tr>\r\n" ) ;
        int len = lst.size() ;
        int cnt = 1 ;
        for( int i = len-1 ; i >= 0 ; i -- ) {
            AccessInfo info = lst.get( i ) ;
            buf.append( "<tr><td>" ).append( cnt ).append( "</td>" ) ;
            buf.append( "<td>" ).append( info.getDate() ).append( "</td>" ) ;
            buf.append( "<td>" ).append( info.getState() ).append( "</td>" ) ;
            buf.append( "<td>" ).append( cutString( info.getUrl(),36) ).append( "</td>" ) ;
            buf.append( "<td>" ).append( info.getAddr() ).append( "</td>" ) ;
            buf.append( "<td>" ).append( cutString( info.getUserAgent(),24 ) ).append( "</td>" ) ;
            buf.append( "</tr>\r\n" ) ;
            cnt ++ ;
        }
        return buf.toString() ;
    }
    
    /**
     * 文字数制限.
     */
    private String cutString( String code,int len ) {
        if( code == null || code.length() <= 0 ) {
            return "&nbsp;" ;
        }
        StringBuilder buf = new StringBuilder() ;
        int b = 0 ;
        for( ;; ) {
            boolean exitFlag = false ;
            String c = null ;
            if( code.length() > len+b ) {
                c = code.substring( b,b+len ) ;
            }
            else {
                c = code.substring( b ) ;
                exitFlag = true ;
            }
            buf.append( c ) ;
            if( exitFlag == false ) {
                buf.append( "<br>" ) ;
                b += len ;
            }
            else {
                break ;
            }
        }
        return buf.toString() ;
    }
}
