package org.maachang.proxy.engine.admin.page ;

import java.net.InetAddress;

import org.maachang.proxy.engine.admin.AbstractAdminNextLogin;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.conf.ProxyOption;
import org.maachang.proxy.engine.conf.SerializableObject;
import org.maachang.proxy.engine.net.http.HttpParams;

/**
 * MaachangProxy新規Proxy追加確認画面.
 * 
 * @version 2008/03/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class AdminCreateProxyTo extends AbstractAdminNextLogin {
    
    /**
     * デフォルトPort番号.
     */
    private static final String DEFAULT_PORT = "3333" ;
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AdminCreateProxyTo( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void nextLogin( AdminConnect conn )
        throws Exception {
        HttpParams params = conn.getParams() ;
        String name = ( String )params.get( "name" ) ;
        String url = ( String )params.get( "url" ) ;
        String hostName = ( String )params.get( "hostName" ) ;
        String port = ( String )params.get( "port" ) ;
        String sessionName = ( String )params.get( "sessionName" ) ;
        String charset = ( String )params.get( "charset" ) ;
        String pcSelect = ( String )params.get( "pcSelect" ) ;
        String mobileSelect = ( String )params.get( "mobileSelect" ) ;
        int portInt = -1 ;
        boolean errorFlag = false ;
        
        // 内容が入力されていない場合.
        if( name == null || ( name = name.trim() ).length() <= 0 ||
            url == null || ( url = url.trim() ).length() <= 0 ||
            hostName == null || ( hostName = hostName.trim() ).length() <= 0 ) {
            if( name == null || name.length() <= 0 ) {
                addErrorMessage( conn,"Proxy名が設定されていません" ) ;
                name = "" ;
                errorFlag = true ;
            }
            if( url == null || url.length() <= 0 ) {
                addErrorMessage( conn,"接続URLが設定されていません" ) ;
                url = "" ;
                errorFlag = true ;
            }
            if( hostName == null || hostName.length() <= 0 ) {
                addErrorMessage( conn,"ホスト名が設定されていません" ) ;
                hostName = "" ;
                errorFlag = true ;
            }
        }
        // 内容が入力されている場合.
        else {
            if( conn.getProxyManager().isName( name ) == true ) {
                addErrorMessage( conn,"指定名[" + name + "]の内容は既に存在します" ) ;
                name = "" ;
                errorFlag = true ;
            }
            try {
                InetAddress.getByName( url ) ;
            } catch( Exception e ) {
                addErrorMessage( conn,"接続URLは不正です:"+e.getMessage() ) ;
                url = "" ;
                errorFlag = true ;
            }
            if( port == null || ( port = port.trim() ).length() <= 0 ) {
                port = DEFAULT_PORT ;
            }
            try {
                portInt = Integer.parseInt( port ) ;
                if( portInt <= -1 ) {
                    addErrorMessage( conn,"指定ポート番号は整数(1～65535)で設定する必要があります." ) ;
                    port = "" ;
                    errorFlag = true ;
                }
            } catch( Exception e ) {
                portInt = -1 ;
                addErrorMessage( conn,"指定ポート番号は数値(1～65535)で設定する必要があります." ) ;
                port = "" ;
                errorFlag = true ;
            }
        }
        // 入力内容が不正な場合.
        if( errorFlag == true ) {
            conn.getViewParams().put( "name",name ) ;
            conn.getViewParams().put( "url",url ) ;
            conn.getViewParams().put( "hostName",hostName ) ;
            conn.getViewParams().put( "port",port ) ;
            conn.getViewParams().put( "sessionName",sessionName ) ;
            conn.getViewParams().put( "charset",charset ) ;
            conn.getViewParams().put( "pcSelect",pcSelect ) ;
            conn.getViewParams().put( "mobileSelect",mobileSelect ) ;
            forward( true,conn,"/AdminCreateProxy" ) ;
        }
        // 正しい値で入力されている.
        else {
            try {
                // 新しいProxyを設定.
                addProxy( conn,name,url,hostName,portInt,sessionName,charset,
                    pcSelect,mobileSelect ) ;
                redirectAdmin( conn,"/AdminProxyList" ) ;
                SerializableObject.getInstance().encodeSerializableByProxy( conn.getProxyManager() ) ;
            } catch( Exception e ) {
                e.printStackTrace() ;
                addErrorMessage( conn,"Proxy設定時にエラーが発生しました:" + e.getMessage() ) ;
                forward( true,conn,"/AdminCreateProxy" ) ;
            }
        }
    }
    
    private void addProxy( AdminConnect conn,String name,String url,String hostName,
        int port,String sessionName,String charset,
        String pcSelect,String mobileSelect )
        throws Exception {
        ProxyOption opt = new ProxyOption() ;
        opt.setName( name ) ;
        opt.setUrl( url ) ;
        opt.setDestUrl( hostName ) ;
        opt.setPort( port ) ;
        if( sessionName == null || ( sessionName = sessionName.trim() ).length() <= 0 ) {
            sessionName = "" ;
        }
        opt.setSessionName( sessionName ) ;
        if( charset == null || ( charset = charset.trim() ).length() <= 0 ) {
            charset = "UTF8" ;
        }
        opt.setCharset( charset ) ;
        opt.setStopService( false ) ;
        opt.setAccessPcFlag( Boolean.parseBoolean( pcSelect ) ) ;
        opt.setAccessMobileFlag( Boolean.parseBoolean( mobileSelect ) ) ;
        conn.getProxyManager().add( opt ) ;
    }

}
