package org.maachang.proxy.engine.admin.page ;

import java.util.ArrayList;

import org.maachang.proxy.engine.admin.AbstractAdminNextLogin;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.conf.SerializableObject;
import org.maachang.proxy.engine.net.http.HttpParams;
import org.maachang.util.AnalysisUtil;
import org.maachang.util.StringUtil;

/**
 * MaachangProxy新規禁止アドレス追加登録.
 * 
 * @version 2008/03/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class AdminCreateRefusalTo extends AbstractAdminNextLogin {
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AdminCreateRefusalTo( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void nextLogin( AdminConnect conn )
        throws Exception {
        HttpParams params = conn.getParams() ;
        String ipaddr = ( String )params.get( "ipaddr" ) ;
        String ipmask = ( String )params.get( "ipmask" ) ;
        boolean errorFlag = false ;
        // 内容が入力されていない場合.
        if( ipaddr == null || ( ipaddr = ipaddr.trim() ).length() <= 0 ||
            ipmask == null || ( ipmask = ipmask.trim() ).length() <= 0 ) {
            if( ipaddr == null || ipaddr.length() <= 0 ) {
                addErrorMessage( conn,"IPアドレスが設定されていません" ) ;
                ipaddr = "" ;
                errorFlag = true ;
            }
            if( ipmask == null || ipmask.length() <= 0 ) {
                addErrorMessage( conn,"IPマスクが設定されていません" ) ;
                ipmask = "" ;
                errorFlag = true ;
            }
        }
        // 内容が入力されている場合.
        else {
            if( isIpAddress( ipaddr ) == false ) {
                addErrorMessage( conn,"IPアドレスのフォーマット形式は不正です" ) ;
                ipaddr = "" ;
                errorFlag = true ;
            }
            if( isMask( ipmask ) == false ) {
                addErrorMessage( conn,"IPマスクが範囲外です" ) ;
                ipmask = "" ;
                errorFlag = true ;
            }
        }
        // 入力内容が不正な場合.
        if( errorFlag == true ) {
            conn.getViewParams().put( "ipaddr",ipaddr ) ;
            conn.getViewParams().put( "ipmask",ipmask ) ;
            forward( true,conn,"/AdminCreateRefusal" ) ;
        }
        // 正しい値で入力されている.
        else {
            try {
                conn.getRefusal().add( ipaddr,ipmask ) ;
                redirectAdmin( conn,"/AdminRefusalList" ) ;
                SerializableObject.getInstance().encodeSerializableByRefusalAddress( conn.getRefusal() ) ;
            } catch( Exception e ) {
                e.printStackTrace() ;
                addErrorMessage( conn,"禁止アドレス設定時にエラーが発生しました:" + e.getMessage() ) ;
                forward( true,conn,"/AdminCreateRefusal" ) ;
            }
        }
    }
    
    /** IPアドレスチェック. */
    private boolean isIpAddress( String ipAddr ) {
        ArrayList<String> lst = StringUtil.cutString( ipAddr,"." ) ;
        if( lst == null || lst.size() != 4) {
            return false ;
        }
        int len = lst.size() ;
        for( int i = 0 ; i < len ; i ++ ) {
            int c = AnalysisUtil.convertInt( lst.get( i ) ) ;
            if( c < 0 || c > 255 ) {
                return false ;
            }
        }
        return true ;
    }
    
    /** マスクが有効か確認. */
    private boolean isMask( String ipMask ) {
        int c = AnalysisUtil.convertInt( ipMask ) ;
        if( c <= 0 || c > 32 ) {
            return false ;
        }
        return true ;
    }
}
