package org.maachang.proxy.engine.admin.page ;

import java.util.HashMap;

import org.maachang.proxy.engine.VersionDef;
import org.maachang.proxy.engine.admin.AbstractAdminPage;
import org.maachang.proxy.engine.admin.AdminConnect;

/**
 * MaachangProxy管理ログイン処理.
 * 
 * @version 2008/03/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class AdminLogin extends AbstractAdminPage {
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AdminLogin( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void execution( AdminConnect conn )
        throws Exception {
        if( conn.getConf().isAuthAdmin() == false ) {
            String key = conn.getSession().createSession() ;
            redirectAdmin( conn,"/AdminMenu",key ) ;
        }
        HashMap<String,String> viewParams = conn.getViewParams() ;
        viewParams.put( "version",VersionDef.getVersion() ) ;
        viewParams.put( "versionDate",VersionDef.getDate() ) ;
    }
}
