package org.maachang.proxy.engine.admin.page ;

import java.util.HashMap;

import org.maachang.proxy.engine.VersionDef;
import org.maachang.proxy.engine.admin.AbstractAdminPage;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.net.http.HttpParams;

/**
 * MaachangProxy管理ログイン判別処理.
 * 
 * @version 2008/03/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class AdminLoginTo extends AbstractAdminPage {
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AdminLoginTo( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void execution( AdminConnect conn )
        throws Exception {
        HttpParams params = conn.getParams() ;
        HashMap<String,String> viewParams = conn.getViewParams() ;
        viewParams.put( "version",VersionDef.getVersion() ) ;
        viewParams.put( "versionDate",VersionDef.getDate() ) ;
        String user = ( String )params.get( "user" ) ;
        String passwd = ( String )params.get( "passwd" ) ;
        if( user == null || ( user = user.trim() ).length() <= 0 ) {
            user = "" ;
        }
        if( passwd == null || ( passwd = passwd.trim() ).length() <= 0 ) {
            passwd = "" ;
        }
        viewParams.put( "user",user ) ;
        if( user.length() <= 0 ) {
            viewParams.put( "errorMessage","ユーザ名を入力してください" ) ;
            forward( conn,"/" ) ;
        }
        else if( conn.getConf().isAuthAdmin() == true && conn.getConf().isAuth( user,passwd ) == false ) {
            viewParams.put( "errorMessage","ユーザ／パスワードが違います" ) ;
            forward( conn,"/" ) ;
        }
        else {
            String key = conn.getSession().createSession() ;
            redirectAdmin( conn,"/AdminMenu",key ) ;
        }
    }
}
