package org.maachang.proxy.engine.admin.page ;

import org.maachang.proxy.engine.admin.AbstractAdminPage;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.admin.AdminSession;

/**
 * MaachangProxyログアウト画面.
 * 
 * @version 2008/03/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class AdminLogout extends AbstractAdminPage {
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AdminLogout( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void execution( AdminConnect conn )
        throws Exception {
        AdminSession session = conn.getSession() ;
        String key = getSessionId( conn ) ;
        if( key != null && ( key = key.trim() ).length() > 0 ) {
            session.removeSession( key ) ;
        }
        redirectAdmin( conn,"/" ) ;
    }
}
