package org.maachang.proxy.engine.admin.page ;

import java.util.HashMap;

import org.maachang.proxy.engine.admin.AbstractAdminNextLogin;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.admin.AdminManager;
import org.maachang.proxy.engine.net.server.ProxyInfo;
import org.maachang.proxy.engine.net.server.ProxyManager;

/**
 * MaachangProxyリスト.
 * 
 * @version 2008/03/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class AdminProxyList extends AbstractAdminNextLogin {
    
    /**
     * 編集コマンドURL.
     */
    private static final String EDIT_COMMAND = AdminManager.ADMIN_URL + "AdminEditProxy?id=" ;
    
    /**
     * 削除コマンドURL.
     */
    private static final String REMOVE_COMMAND = AdminManager.ADMIN_URL + "AdminRemoveProxy?id=" ;
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AdminProxyList( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void nextLogin( AdminConnect conn )
        throws Exception {
        HashMap<String,String> viewParams = conn.getViewParams() ;
        viewParams.put( "viewCount",String.valueOf( conn.getProxyManager().size() ) ) ;
        viewParams.put( "viewList",viewProxyList( conn ) ) ;
    }
    
    /**
     * Proxyデータを表示.
     */
    private String viewProxyList( AdminConnect conn )
        throws Exception {
        ProxyManager proxyManager = conn.getProxyManager() ;
        StringBuilder buf = new StringBuilder() ;
        buf.append( "<tr><th>項番</th>" ) ;
        buf.append( "<th>Proxy名</th>" ) ;
        buf.append( "<th>接続URL</th>" ) ;
        buf.append( "<th>アクセス先<BR>Address</th>" ) ;
        buf.append( "<th>接続ポート<BR>番号</th>" ) ;
        buf.append( "<th>session<BR>Name</th>" ) ;
        buf.append( "<th>charset</th>" ) ;
        buf.append( "<th>stop</th>" ) ;
        buf.append( "<th>pc</th>" ) ;
        buf.append( "<th>mobile</th>" ) ;
        buf.append( "<th>useLength</th>" ) ;
        buf.append( "<th>[コマンド]</th>" ) ;
        buf.append( "</tr>\r\n" ) ;
        int len = proxyManager.size() ;
        for( int i = 0 ; i < len ; i ++ ) {
            ProxyInfo info = proxyManager.get( i ) ;
            if( info == null ) {
                continue ;
            }
            buf.append( "<tr><td>" ).append( (i+1) ).append( "</td>" ) ;
            buf.append( "<td>" ).append( info.getName() ).append( "</td>" ) ;
            buf.append( "<td>" ).append( info.getUrl() ).append( "</td>" ) ;
            buf.append( "<td>" ).append( info.getDestUrl() ).append( "</td>" ) ;
            buf.append( "<td>" ).append( info.getPort() ).append( "</td>" ) ;
            
            if( info.getSessionName() == null || info.getSessionName().length() <= 0 ) {
                buf.append( "<td>" ).append( "&nbsp;" ).append( "</td>" ) ;
            }
            else {
                buf.append( "<td>" ).append( info.getSessionName() ).append( "</td>" ) ;
            }
            buf.append( "<td>" ).append( info.getCharset() ).append( "</td>" ) ;
            buf.append( "<td>" ).append( info.isStopService() ).append( "</td>" ) ;
            buf.append( "<td>" ).append( info.isAccessPcFlag() ).append( "</td>" ) ;
            buf.append( "<td>" ).append( info.isAccessMobileFlag() ).append( "</td>" ) ;
            if( info.isStopService() == true ) {
                buf.append( "<td>×</td>" ) ;
            }
            else {
                buf.append( "<td>" ).append( info.getHttpPoolingConnector().getUseLength() ).append( "</td>" ) ;
            }
            buf.append( "<td>" ) ;
                buf.append( "<a href=\"" ).append( EDIT_COMMAND ).append( i ).
                    append( "&" ).append( getSessionIdByGetParam( conn ) ).
                    append( "\">編集</a>" ) ;
                buf.append( "<BR>" ) ;
                buf.append( "<a href=\"" ).append( REMOVE_COMMAND ).append( i ).
                    append( "&" ).append( getSessionIdByGetParam( conn ) ).
                    append( "\">削除</a>" ) ;
            buf.append( "</td>" ) ;
            buf.append( "</tr>\r\n" ) ;
        }
        return buf.toString() ;
    }
}
