package org.maachang.proxy.engine.admin.page ;

import java.util.HashMap;

import org.maachang.proxy.engine.admin.AbstractAdminNextLogin;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.admin.AdminManager;
import org.maachang.proxy.engine.conf.RefusalAddressManager;
import org.maachang.util.NetMask;

/**
 * MaachangProxy禁止アドレスリスト.
 * 
 * @version 2008/03/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class AdminRefusalList extends AbstractAdminNextLogin {
    
    /**
     * コマンドURL.
     */
    private static final String COMMAND = AdminManager.ADMIN_URL + "AdminRemoveRefusal?id=" ;
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AdminRefusalList( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void nextLogin( AdminConnect conn )
        throws Exception {
        HashMap<String,String> viewParams = conn.getViewParams() ;
        viewParams.put( "viewCount",String.valueOf( conn.getRefusal().size() ) ) ;
        viewParams.put( "viewList",viewProxyList( conn ) ) ;
    }
    
    /**
     * Proxyデータを表示.
     */
    private String viewProxyList( AdminConnect conn )
        throws Exception {
    	RefusalAddressManager refusal = conn.getRefusal() ;
        StringBuilder buf = new StringBuilder() ;
        buf.append( "<tr><th>項番</th>" ) ;
        buf.append( "<th>禁止アドレス</th>" ) ;
        buf.append( "<th>[コマンド]</th>" ) ;
        buf.append( "</tr>\r\n" ) ;
        int len = refusal.size() ;
        for( int i = 0 ; i < len ; i ++ ) {
            NetMask info = refusal.get( i ) ;
            if( info == null ) {
                continue ;
            }
            buf.append( "<tr><td>" ).append( (i+1) ).append( "</td>" ) ;
            buf.append( "<td>" ).append( info.getNetworkAddress() ).append( "/" ).
                append( info.getNetMask() ).append( "</td>" ) ;
            buf.append( "<td>" ).append( "<a href=\"" ).append( COMMAND ).append( i ).
                append( "&" ).append( getSessionIdByGetParam( conn ) ).
                append( "\">削除</a>" ).append( "</td>" ) ;
            buf.append( "</tr>\r\n" ) ;
        }
        return buf.toString() ;
    }
}
