package org.maachang.proxy.engine.admin.page ;

import java.util.HashMap;

import org.maachang.proxy.engine.admin.AbstractAdminNextLogin;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.net.http.HttpParams;
import org.maachang.proxy.engine.net.server.ProxyInfo;
import org.maachang.util.AnalysisUtil;

/**
 * MaachangProxyProxy削除画面.
 * 
 * @version 2008/03/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class AdminRemoveProxy extends AbstractAdminNextLogin {
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AdminRemoveProxy( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void nextLogin( AdminConnect conn )
        throws Exception {
        HttpParams params = conn.getParams() ;
        String id = ( String )params.get( "id" ) ;
        boolean backFlag = false ;
        if( id == null || ( id = id.trim() ).length() <= 0 ) {
            backFlag = true ;
        }
        int idInt = AnalysisUtil.convertInt( id ) ;
        if( idInt <= -1 ) {
            backFlag = false ;
        }
        ProxyInfo proxy = conn.getProxyManager().get( idInt ) ;
        if( proxy == null ) {
            backFlag = true ;
        }
        if( backFlag == true ) {
            redirectAdmin( conn,"/AdminProxyList" ) ;
        }
        else {
            HashMap<String,String> viewParams = conn.getViewParams() ;
            viewParams.put( "id",id ) ;
            viewParams.put( "name",proxy.getName() ) ;
            viewParams.put( "url",proxy.getUrl() ) ;
            viewParams.put( "hostName",proxy.getDestUrl() ) ;
            viewParams.put( "port",String.valueOf( proxy.getPort() ) ) ;
            if( proxy.getSessionName() == null || proxy.getSessionName().length() <= 0 ) {
                viewParams.put( "sessionName","&nbsp;" ) ;
            }
            else {
                viewParams.put( "sessionName",proxy.getSessionName() ) ;
            }
            viewParams.put( "charset",proxy.getCharset() ) ;
            viewParams.put( "stop",String.valueOf( proxy.isStopService() ) ) ;
            viewParams.put( "pc",String.valueOf(proxy.isAccessPcFlag() ) ) ;
            viewParams.put( "mobile",String.valueOf(proxy.isAccessMobileFlag() ) ) ;
        }
    }
}
