package org.maachang.proxy.engine.admin.page ;

import java.util.HashMap;

import org.maachang.proxy.engine.admin.AbstractAdminNextLogin;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.net.http.HttpParams;
import org.maachang.util.AnalysisUtil;
import org.maachang.util.NetMask;

/**
 * MaachangProxy禁止アドレス削除画面.
 * 
 * @version 2008/03/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class AdminRemoveRefusal extends AbstractAdminNextLogin {
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AdminRemoveRefusal( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void nextLogin( AdminConnect conn )
        throws Exception {
        HttpParams params = conn.getParams() ;
        String id = ( String )params.get( "id" ) ;
        boolean backFlag = false ;
        if( id == null || ( id = id.trim() ).length() <= 0 ) {
            backFlag = true ;
        }
        int idInt = AnalysisUtil.convertInt( id ) ;
        if( idInt <= -1 ) {
            backFlag = false ;
        }
        NetMask mask = conn.getRefusal().get( idInt ) ;
        if( mask == null ) {
            backFlag = true ;
        }
        if( backFlag == true ) {
            redirectAdmin( conn,"/AdminRefusalList" ) ;
        }
        else {
            HashMap<String,String> viewParams = conn.getViewParams() ;
            viewParams.put( "id",id ) ;
            viewParams.put( "ipaddr",mask.getNetworkAddress() ) ;
            viewParams.put( "ipmask",mask.getNetMask() ) ;
        }
    }
}
