package org.maachang.proxy.engine.admin.page ;

import org.maachang.proxy.engine.admin.AbstractAdminNextLogin;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.conf.SerializableObject;
import org.maachang.proxy.engine.net.http.HttpParams;
import org.maachang.util.AnalysisUtil;

/**
 * MaachangProxy禁止アドレス削除登録.
 * 
 * @version 2008/03/26
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class AdminRemoveRefusalTo extends AbstractAdminNextLogin {
    
    /**
     * コンストラクタ.
     * @param name 対象名を設定します.
     * @exception Exception 例外.
     */
    public AdminRemoveRefusalTo( String name ) throws Exception {
        super( name ) ;
    }
    
    /**
     * 実行処理.
     * @param conn 対象のコネクション情報を設定します.
     * @exception Exception 例外.
     */
    public void nextLogin( AdminConnect conn )
        throws Exception {
        HttpParams params = conn.getParams() ;
        String id = ( String )params.get( "id" ) ;
        if( id == null || ( id = id.trim() ).length() <= 0 || AnalysisUtil.convertInt( id ) <= -1 ) {
            redirectAdmin( conn,"/AdminRefusalList" ) ;
        }
        else {
            try {
                conn.getRefusal().remove( AnalysisUtil.convertInt( id ) ) ;
            } catch( Exception e ) {
            }
            SerializableObject.getInstance().encodeSerializableByRefusalAddress( conn.getRefusal() ) ;
            redirectAdmin( conn,"/AdminRefusalList" ) ;
        }
    }
    
}
