package org.maachang.proxy.engine.conf;

import java.io.Serializable;

/**
 * １つのプロキシオプション.
 * 
 * @version 2008/03/25
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class ProxyOption implements Serializable {
    /** シリアライズID. */
    private static final long serialVersionUID = 7758997775913038196L;
    
    /** Proxy名 */
    private String name = null ;
    
    /** Proxy元URL. */
    private String url = null ;
    
    /** 接続先アドレス. */
    private String destUrl = null ;
    
    /** 接続ポート番号. */
    private int port = -1 ;
    
    /** サービス停止中. */
    private boolean stopService = false ;
    
    /** PCアクセス許可フラグ. */
    private boolean accessPcFlag = true ;
    
    /** 携帯アクセス許可フラグ. */
    private boolean accessMobileFlag = true ;
    
    /** セッション名 */
    private String sessionName = null ;
    
    /** 接続先キャラクタセット. */
    private String charset = null ;
    
    public ProxyOption() {
        
    }

    /**
     * destUrl を取得.
     * <BR><BR>
     * @return destUrl が返されます.
     */
    public String getDestUrl() {
        return destUrl;
    }

    /**
     * destUrl を設定.
     * <BR><BR>
     * @param destUrl destUrl を設定します.
     */
    public void setDestUrl(String destUrl) {
        this.destUrl = destUrl;
    }

    /**
     * name を取得.
     * <BR><BR>
     * @return name が返されます.
     */
    public String getName() {
        return name;
    }

    /**
     * name を設定.
     * <BR><BR>
     * @param name name を設定します.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() {
        return port;
    }

    /**
     * port を設定.
     * <BR><BR>
     * @param port port を設定します.
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * url を取得.
     * <BR><BR>
     * @return url が返されます.
     */
    public String getUrl() {
        return url;
    }

    /**
     * url を設定.
     * <BR><BR>
     * @param url url を設定します.
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * stopService を取得.
     * <BR><BR>
     * @return stopService が返されます.
     */
    public boolean isStopService() {
        return stopService;
    }

    /**
     * stopService を設定.
     * <BR><BR>
     * @param stopService stopService を設定します.
     */
    public void setStopService(boolean stopService) {
        this.stopService = stopService;
    }

    /**
     * accessMobileFlag を取得.
     * <BR><BR>
     * @return accessMobileFlag が返されます.
     */
    public boolean isAccessMobileFlag() {
        return accessMobileFlag;
    }

    /**
     * accessMobileFlag を設定.
     * <BR><BR>
     * @param accessMobileFlag accessMobileFlag を設定します.
     */
    public void setAccessMobileFlag(boolean accessMobileFlag) {
        this.accessMobileFlag = accessMobileFlag;
    }

    /**
     * accessPcFlag を取得.
     * <BR><BR>
     * @return accessPcFlag が返されます.
     */
    public boolean isAccessPcFlag() {
        return accessPcFlag;
    }

    /**
     * accessPcFlag を設定.
     * <BR><BR>
     * @param accessPcFlag accessPcFlag を設定します.
     */
    public void setAccessPcFlag(boolean accessPcFlag) {
        this.accessPcFlag = accessPcFlag;
    }

    /**
     * sessionName を取得.
     * <BR><BR>
     * @return sessionName が返されます.
     */
    public String getSessionName() {
        return sessionName;
    }

    /**
     * sessionName を設定.
     * <BR><BR>
     * @param sessionName sessionName を設定します.
     */
    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    /**
     * charset を取得.
     * <BR><BR>
     * @return charset が返されます.
     */
    public String getCharset() {
        return charset;
    }

    /**
     * charset を設定.
     * <BR><BR>
     * @param charset charset を設定します.
     */
    public void setCharset(String charset) {
        this.charset = charset;
    }
}
