package org.maachang.proxy.engine.conf;

import java.io.Serializable;

/**
 * １つのプロキシオプション群.
 * 
 * @version 2008/03/30
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class ProxyOptions implements Serializable {
    /** シリアルID. */
    private static final long serialVersionUID = 8590836669411287011L;
    /** プロキシオプション群. */
    private ProxyOption[] options = null ;
    
    /**
     * コンストラクタ.
     */
    public ProxyOptions() {
        
    }
    
    /**
     * コンストラクタ.
     * @param size 対象のプロキシオプション数を設定します.
     */
    public ProxyOptions( int size ) {
        if( size <= 0 ) {
            return ;
        }
        this.options = new ProxyOption[ size ] ;
    }
    
    /**
     * データ追加.
     * @param option 対象のオプションを設定します.
     * @param no 対象の項番を設定します.
     */
    public void set( ProxyOption option,int no ) {
        if( options == null || no <= -1 || no >= options.length ) {
            return ;
        }
        this.options[ no ] = option ;
    }
    
    /**
     * データ取得.
     * @param no 対象の項番を設定します.
     * @return ProxyOption プロキシオプション情報が返されます.
     */
    public ProxyOption get( int no ) {
        if( options == null || no <= -1 || no >= options.length ) {
            return null ;
        }
        return this.options[ no ] ;
    }
    
    /**
     * プロキシオプション数が返されます.
     * @return int プロキシオプション数が返されます.
     */
    public int size() {
        if( options == null ) {
            return 0 ;
        }
        return options.length ;
    }
}
