package org.maachang.proxy.engine.conf ;

import org.maachang.proxy.engine.conf.ProxyOptions;
import org.maachang.proxy.engine.conf.RefusalAddressManager;
import org.maachang.proxy.engine.net.server.ProxyManager;
import org.maachang.util.FileUtil;

/**
 * オブジェクトをシリアライズする専用オブジェクト.
 * 
 * @version 2008/03/25
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class SerializableObject {
    private static final String PROXY_SERIALIZABLE_NAME = "./.prxy" ;
    private static final String REFUSAL_SERIALIZABLE_NAME = "./.rfsl" ;
    private static final String ACCESS_SERIALIZABLE_NAME = "./.acc" ;
    private static final SerializableObject SNGL = new SerializableObject() ;
    
    /**
     * コンストラクタ.
     */
    private SerializableObject() {
        
    }
    
    /** オブジェクトを取得. */
    public static final SerializableObject getInstance() {
        return SNGL ;
    }
    
    /** ProxyManagerをシリアライズ. */
    public synchronized void encodeSerializableByProxy( ProxyManager man )
        throws Exception {
        if( man == null ) {
            FileUtil.encodeSerializable( PROXY_SERIALIZABLE_NAME,new ProxyOptions() ) ;
        }
        FileUtil.encodeSerializable( PROXY_SERIALIZABLE_NAME,man.convertProxyOptions() ) ;
    }
    
    /** RefusalAddressConfigをシリアライズ. */
    public synchronized void encodeSerializableByRefusalAddress( RefusalAddressManager conf )
        throws Exception {
        if( conf == null ) {
            FileUtil.encodeSerializable( REFUSAL_SERIALIZABLE_NAME,new RefusalAddressManager() ) ;
        }
        FileUtil.encodeSerializable( REFUSAL_SERIALIZABLE_NAME,conf ) ;
    }
    
    /** AccessManagerをシリアライズ. */
    public synchronized void encodeSerializableByAccess( AccessManager man )
        throws Exception {
        if( man == null ) {
            FileUtil.encodeSerializable( ACCESS_SERIALIZABLE_NAME,new AccessManager() ) ;
        }
        FileUtil.encodeSerializable( ACCESS_SERIALIZABLE_NAME,man ) ;
    }
    
    /** ProxyManagerをシリアライズから復帰. */
    public synchronized ProxyManager decodeSerializeByProxy()
        throws Exception {
        if( FileUtil.isFileExists( PROXY_SERIALIZABLE_NAME ) ) {
            Object o = FileUtil.decodeSerializable( PROXY_SERIALIZABLE_NAME ) ;
            if( o != null && o instanceof ProxyOptions ) {
                return new ProxyManager( ( ProxyOptions )o ) ;
            }
        }
        return new ProxyManager() ;
    }
    
    /** RefusalAddressConfigをシリアライズから復帰. */
    public synchronized RefusalAddressManager decodeSerializeByRefusalAddress()
        throws Exception {
        if( FileUtil.isFileExists( REFUSAL_SERIALIZABLE_NAME ) ) {
            Object o = FileUtil.decodeSerializable( REFUSAL_SERIALIZABLE_NAME ) ;
            if( o != null && o instanceof RefusalAddressManager ) {
                return ( RefusalAddressManager )o ;
            }
        }
        return new RefusalAddressManager() ;
    }
    
    /** AccessManagerをシリアライズから復帰. */
    public synchronized AccessManager decodeSerializeByAccess()
        throws Exception {
        if( FileUtil.isFileExists( ACCESS_SERIALIZABLE_NAME ) ) {
            Object o = FileUtil.decodeSerializable( ACCESS_SERIALIZABLE_NAME ) ;
            if( o != null && o instanceof AccessManager ) {
                return ( AccessManager )o ;
            }
        }
        return new AccessManager() ;
    }

}
