package org.maachang.proxy.engine.mobile ;

import org.maachang.proxy.engine.mobile.carrier.MobileData;
import org.maachang.proxy.engine.mobile.emoji.EmojiConfig;
import org.maachang.proxy.engine.net.RequestInfo;

/**
 * モバイルアクセス用情報.
 *
 * @version 2008/04/08
 * @author  masahito suzuki
 * @since   MaachangProxy 1.01
 */
public class MobileInfo {
    
    /** リクエスト情報. */
    private RequestInfo request = null ;
    
    /** 絵文字変換マネージャ */
    private EmojiConfig emojiConfig = null ;
    
    /** アクセス機種データ */
    private MobileData mobileData = null ;
    
    private MobileInfo() {
    }
    
    /**
     * コンストラクタ.
     * @param request 対象のリクエスト情報を設定します.
     * @param emojiConfig 絵文字コンフィグ情報を設定します.
     * @param mobileData 対象のアクセス機種データを設定します.
     */
    public MobileInfo( RequestInfo request,EmojiConfig emojiConfig,MobileData mobileData ) {
        this.request = request ;
        this.emojiConfig = emojiConfig ;
        this.mobileData = mobileData ;
    }

    /**
     * emojiConfig を取得.
     * <BR><BR>
     * @return emojiConfig が返されます.
     */
    public EmojiConfig getEmojiConfig() {
        return emojiConfig;
    }

    /**
     * mobileData を取得.
     * <BR><BR>
     * @return mobileData が返されます.
     */
    public MobileData getMobileData() {
        return mobileData;
    }

    /**
     * request を取得.
     * <BR><BR>
     * @return request が返されます.
     */
    public RequestInfo getRequest() {
        return request;
    }
    
}


