package org.maachang.proxy.engine.mobile.carrier ;

/**
 * 1つの機種データ.
 *
 * @version 2008/04/08
 * @author  masahito suzuki
 * @since   MaachangProxy 1.01
 */
public class MobileData {
    
    /**
     * キャリア名.
     */
    private String carrier = null ;
    
    /**
     * 機種名.
     */
    private String code = null ;
    
    /**
     * 機種タイプ.
     */
    private String type = null ;
    
    /**
     * ユーザエージェント.
     */
    private String userAgent = null ;
    
    /**
     * 解像度:x.
     */
    private int x = -1 ;
    
    /**
     * 解像度:y.
     */
    private int y = -1 ;
    
    /**
     * 画像サポート:jpeg.
     */
    private boolean jpegFlag = false ;
    
    /**
     * 画像サポート:gif
     */
    private boolean gifFlag = false ;
    
    /**
     * 画像サポート:png
     */
    private boolean pngFlag = false ;
    
    /**
     * Flashサポート.
     */
    private boolean flashFlag = false ;

    /**
     * carrier を取得.
     * <BR><BR>
     * @return carrier が返されます.
     */
    public String getCarrier() {
        return carrier;
    }

    /**
     * carrier を設定.
     * <BR><BR>
     * @param carrier carrier を設定します.
     */
    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    /**
     * code を取得.
     * <BR><BR>
     * @return code が返されます.
     */
    public String getCode() {
        return code;
    }

    /**
     * code を設定.
     * <BR><BR>
     * @param code code を設定します.
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * type を取得.
     * <BR><BR>
     * @return type が返されます.
     */
    public String getType() {
        return type;
    }

    /**
     * type を設定.
     * <BR><BR>
     * @param type type を設定します.
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * flashFlag を取得.
     * <BR><BR>
     * @return flashFlag が返されます.
     */
    public boolean isFlashFlag() {
        return flashFlag;
    }

    /**
     * flashFlag を設定.
     * <BR><BR>
     * @param flashFlag flashFlag を設定します.
     */
    public void setFlashFlag(boolean flashFlag) {
        this.flashFlag = flashFlag;
    }

    /**
     * gifFlag を取得.
     * <BR><BR>
     * @return gifFlag が返されます.
     */
    public boolean isGifFlag() {
        return gifFlag;
    }

    /**
     * gifFlag を設定.
     * <BR><BR>
     * @param gifFlag gifFlag を設定します.
     */
    public void setGifFlag(boolean gifFlag) {
        this.gifFlag = gifFlag;
    }

    /**
     * jpegFlag を取得.
     * <BR><BR>
     * @return jpegFlag が返されます.
     */
    public boolean isJpegFlag() {
        return jpegFlag;
    }

    /**
     * jpegFlag を設定.
     * <BR><BR>
     * @param jpegFlag jpegFlag を設定します.
     */
    public void setJpegFlag(boolean jpegFlag) {
        this.jpegFlag = jpegFlag;
    }

    /**
     * pngFlag を取得.
     * <BR><BR>
     * @return pngFlag が返されます.
     */
    public boolean isPngFlag() {
        return pngFlag;
    }

    /**
     * pngFlag を設定.
     * <BR><BR>
     * @param pngFlag pngFlag を設定します.
     */
    public void setPngFlag(boolean pngFlag) {
        this.pngFlag = pngFlag;
    }

    /**
     * userAgent を取得.
     * <BR><BR>
     * @return userAgent が返されます.
     */
    public String getUserAgent() {
        return userAgent;
    }

    /**
     * userAgent を設定.
     * <BR><BR>
     * @param userAgent userAgent を設定します.
     */
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    /**
     * x を取得.
     * <BR><BR>
     * @return x が返されます.
     */
    public int getX() {
        return x;
    }

    /**
     * x を設定.
     * <BR><BR>
     * @param x x を設定します.
     */
    public void setX(int x) {
        this.x = x;
    }

    /**
     * y を取得.
     * <BR><BR>
     * @return y が返されます.
     */
    public int getY() {
        return y;
    }

    /**
     * y を設定.
     * <BR><BR>
     * @param y y を設定します.
     */
    public void setY(int y) {
        this.y = y;
    }
    
    /**
     * 文字列に変換.
     * @return String 文字列が返されます.
     */
    public String toString() {
        return new StringBuilder().
            append( " carrier:" ).append( carrier ).
            append( " code:" ).append( code ).
            append( " type:" ).append( type ).
            append( " userAgent:" ).append( userAgent ).
            append( " x:" ).append( x ).
            append( " y:" ).append( y ).
            append( " jpegFlag:" ).append( jpegFlag ).
            append( " gifFlag:" ).append( gifFlag ).
            append( " pngFlag:" ).append( pngFlag ).
            append( " flashFlag:" ).append( flashFlag ).
            toString() ;
    }
}
