package org.maachang.proxy.engine.mobile.convert ;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

/**
 * 各絵文字CSV情報を変換.
 *
 * @version 2008/04/08
 * @author  masahito suzuki
 * @since   MaachangProxy 1.01
 */
public class ConvertCsvEmoji {
    public static final void main( String[] args ) throws Exception {
        String name = args[ 0 ] ;
        String opt = args[ 1 ] ;
        
        BufferedReader br = new BufferedReader( new InputStreamReader( new FileInputStream( name ),"ISO-8859-1" ) ) ;
        BufferedOutputStream bo = new BufferedOutputStream( new FileOutputStream( name + ".conf" ) ) ;
        opt = opt.trim().toLowerCase() ;
        int cnt = 0 ;
        for( ;; ) {
            String oneLine = br.readLine() ;
            if( oneLine == null ) {
                break ;
            }
            oneLine = oneLine.trim() ;
            if( oneLine.length() <= 0 ) {
                continue ;
            }
            //String[] s = oneLine.split( "|" ) ;
            String[] s = cutCode( oneLine,"|" ) ;
            System.out.println( "len:" + s.length ) ;
            if( s != null && s.length > 0 ) {
                int len = s.length ;
                int x = 1 ;
                if( cnt == 1 ) {
                    x = 201 ;
                }
                for( int i = 0 ; i < len ; i ++ ) {
                    String key = String.valueOf( x ) ;
                    key = "e-"+"000".substring( key.length() ) + key ;
                    String value = s[ i ].trim() ;
                    if( value.indexOf( "/" ) > 0 ) {
                        value = value.substring( 0,value.indexOf( "/" ) ) ;
                    }
                    if( value.length() <= 0 ) {
                        value = "=" ;
                    }
                    else if( value.startsWith( "[" ) == false ) {
                        if( "hex".equals( opt ) ) {
                            value = "0x" + value ;
                        }
                        else if( "binary".equals( opt ) ){
                            StringBuilder b = new StringBuilder() ;
                            b.append( "0x1b" ) ;
                            byte[] binary = value.getBytes( "ISO-8859-1" ) ;
                            for( int j = 0 ; j < binary.length ; j ++ ) {
                                String xx = Integer.toHexString( ( int )( binary[ j ] & 0x000000ff ) ) ;
                                b.append( "00".substring( xx.length() ) ) ;
                                b.append( xx ) ;
                            }
                            b.append( "0f" ) ;
                            value = b.toString() ;
                        }
                    }
                    bo.write( ( key+"=\""+value+"\"\r\n" ).getBytes( "ISO-8859-1" ) ) ;
                    x ++ ;
                }
                cnt ++ ;
            }
        }
        bo.flush() ;
        bo.close() ;
        br.close() ;
    }
    private static final String[] cutCode( String string,String code ) {
        ArrayList<String> lst = new ArrayList<String>() ;
        int b = 0 ;
        for( ;; ) {
            int p = string.indexOf( code,b ) ;
            if( p <= -1 ) {
                lst.add( string.substring( b ) ) ;
                break ;
            }
            lst.add( string.substring( b,p ) ) ;
            b = p + code.length() ;
        }
        int len = lst.size() ;
        String[] ret = new String[ len ] ;
        for( int i = 0 ; i < len ; i ++ ) {
            ret[ i ] = lst.get( i ) ;
        }
        return ret ;
    }
}


