package org.maachang.proxy.engine.mobile.convert ;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

import org.maachang.util.conf.Config;
import org.maachang.util.conf.ReadIni;

/**
 * SoftbankPostデータを変換.
 *
 * @version 2008/04/18
 * @author  masahito suzuki
 * @since   MaachangProxy 1.04
 */
public class ConvertSoftbankPost {
    public static final void main( String[] args ) throws Exception {
        String name = args[ 0 ] ;
        String conf = args[ 1 ] ;
        
        BufferedReader br = new BufferedReader( new InputStreamReader( new FileInputStream( name ),"ISO-8859-1" ) ) ;
        BufferedReader confReader = new BufferedReader( new InputStreamReader( new FileInputStream( conf ),"UTF8" ) ) ;
        Config srcConf = new Config() ;
        ReadIni.analisys( srcConf,confReader ) ;
        confReader.close() ;
        confReader = null ;
        BufferedOutputStream bo = null ;
        HashMap<String,ArrayList<String>> index = index( srcConf ) ;
        ArrayList<SoftbankValue> lst = new ArrayList<SoftbankValue>() ;
        try {
            for( ;; ) {
                String oneLine = br.readLine() ;
                if( oneLine == null ) {
                    break ;
                }
                oneLine = oneLine.trim() ;
                if( oneLine.length() <= 0 ) {
                    continue ;
                }
                String[] s = cutCode( oneLine,"|" ) ;
                if( s == null || s.length <= 0 ) {
                    System.out.println( "error:データが存在しません" ) ;
                    return ;
                }
                int len  = s.length ;
                System.out.println( "len:" + len ) ;
                int cnt = 0 ;
                for( int i = 0 ; i < len ; i += 2 ) {
                    String k = s[ i ] ;
                    if( k == null || ( k = k.trim() ).length() <= 0 ) {
                        continue ;
                    }
                    String v = s[ i+1 ] ;
                    if( v == null || ( v = v.trim() ).length() <= 0 ) {
                        continue ;
                    }
                    k = "0x"+k.toUpperCase() ;
                    v = "0x"+v.toUpperCase() ;
                    System.out.println( "["+i+"]:" + " k:" + k + " v:" + v ) ;
                    ArrayList<String> x = index.get( k ) ;
                    if( x == null ) {
                        continue ;
                    }
                    int lenJ = x.size() ;
                    for( int j = 0 ; j < lenJ ; j ++ ) {
                    	lst.add( new SoftbankValue( x.get( j ),v ) ) ;
                    }
                    cnt ++ ;
                }
                System.out.println( "cnt:" + cnt ) ;
                if( lst.size() <= 0 ) {
                    System.out.println( "error:出力対象のデータは存在しません" ) ;
                    return ;
                }
                Object[] o = lst.toArray() ;
                Arrays.sort( o ) ;
                len = o.length ;
                bo = new BufferedOutputStream( new FileOutputStream( name + ".conf" ) ) ;
                for( int i = 0 ; i < len ; i ++ ) {
                    bo.write( ( ( SoftbankValue )o[i] ).toString().getBytes( "UTF8" ) ) ;
                    bo.write( "\r\n".getBytes( "UTF8" ) ) ;
                }
                break ;
            }
        } finally {
            if( bo != null ) {
                bo.flush() ;
                bo.close() ;
            }
            if( br != null ) {
                br.close() ;
            }
        }
    }
    private static final String[] cutCode( String string,String code ) {
        ArrayList<String> lst = new ArrayList<String>() ;
        int b = 0 ;
        for( ;; ) {
            int p = string.indexOf( code,b ) ;
            if( p <= -1 ) {
                lst.add( string.substring( b ) ) ;
                break ;
            }
            lst.add( string.substring( b,p ) ) ;
            b = p + code.length() ;
        }
        int len = lst.size() ;
        String[] ret = new String[ len ] ;
        for( int i = 0 ; i < len ; i ++ ) {
            ret[ i ] = lst.get( i ) ;
        }
        return ret ;
    }
    private static final String SECTION = "softbank-next" ;
    private static final HashMap<String,ArrayList<String>> index( Config conf ) throws Exception {
        String[] key = conf.getKeys( SECTION ) ;
        if( key == null || key.length <= 0 ) {
            throw new IOException( "softbankの情報は存在しません" ) ;
        }
        int len = key.length ;
        HashMap<String,ArrayList<String>> ret = new HashMap<String,ArrayList<String>>() ;
        for( int i = 0 ; i < len ; i ++ ) {
            String k = key[ i ] ;
            if( k.startsWith( "e-" ) == false ) {
                continue ;
            }
            String v = conf.get( SECTION,k,0 ) ;
            System.out.println( "@[" + i + "]:" + "k:" + k + " v:" + v ) ;
            if( v == null || v.startsWith( "0x" ) == false ) {
                continue ;
            }
            if( ret.containsKey( v ) == true ) {
            	ArrayList<String> ary = ret.get( v ) ;
            	ary.add( k ) ;
            }
            else {
            	ArrayList<String> ary = new ArrayList<String>() ;
            	ret.put( v,ary ) ;
            	ary.add( k ) ;
            }
        }
        return ret ;
    }
    
}

class SoftbankValue implements Comparable<SoftbankValue> {
    private String key = null ;
    private String value = null ;
    public SoftbankValue( String key,String value ) {
        this.key = key ;
        this.value = value ;
    }
    public void setKey( String key ) {
        this.key = key ;
    }
    public String getKey() {
        return this.key ;
    }
    public void setValue( String value ) {
        this.value = value ;
    }
    public String getValue() {
        return this.value ;
    }
    public int compareTo( SoftbankValue o ) {
        return key.compareTo( o.getKey() ) ;
    }
    public String toString() {
        return new StringBuilder().append( key ).append( "=\"" ).append( value ).append( "\"" ).toString() ;
    }
}

