package org.maachang.proxy.engine.mobile.emoji ;

import java.util.ArrayList;
import java.util.HashSet;

import org.maachang.util.CharsetMask;
import org.maachang.util.StringUtil;

/**
 * 絵文字タイプ.
 * 
 * @version 2008/04/19
 * @author masahito suzuki
 * @since MaachangProxy 1.04
 */
public class EmojiType {
    private String charset = null ;
    private HashSet<String> types = null ;
    private EmojiType() {
    }
    public EmojiType( String charset,String type ) {
        if( type == null || type.length() <= 0 ) {
            this.types = null ;
        }
        else {
            ArrayList<String> lst = StringUtil.cutString( type,", 　\t" ) ;
            int len = lst.size() ;
            HashSet<String> t = new HashSet<String>() ;
            for( int i = 0 ; i < len ; i ++ ) {
                t.add( lst.get( i ).toLowerCase() ) ;
            }
            this.types = t ;
        }
        this.charset = CharsetMask.getCharset( charset ) ;
    }
    
    public String getCharset() {
        return this.charset ;
    }
    
    public boolean isType( String type ) {
        if( type == null || ( type = type.trim() ).length() <= 0 ) {
            return false ;
        }
        else if( types == null ) {
            return false ;
        }
        return types.contains( type.toLowerCase() ) ;
    }
    
    public Object[] getTypes() {
        if( types == null ) {
            return null ;
        }
        return types.toArray() ;
    }
}
