package org.maachang.proxy.engine.mobile.emoji.image ;

import java.util.HashMap;

import org.maachang.util.FileUtil;

/**
 * 絵文字(PC用)イメージキャッシュ.
 * 
 * @version 2008/04/08
 * @author masahito suzuki
 * @since MaachangProxy 1.01
 */
public class EmojiImageCache {
    
    /**
     * 絵文字URLヘッダ.
     */
    public static final String URL_HEAD = "/@emoji/" ;
    
    /**
     * パス.
     */
    private static final String PATH = "org/maachang/proxy/engine/mobile/emoji/image" ;
    
    /**
     * 絵文字キャッシュ.
     */
    private HashMap<String,byte[]> cache = null ;
    
    /**
     * コンストラクタ.
     */
    private EmojiImageCache() {
        cache = new HashMap<String,byte[]>() ;
    }
    
    /**
     * オブジェクト.
     */
    private static final EmojiImageCache SNGL = new EmojiImageCache() ;
    
    /**
     * オブジェクトを取得.
     * @return EmojiImageCache オブジェクトが返されます.
     */
    public static final EmojiImageCache getInstance() {
        return SNGL ;
    }
    
    /**
     * イメージオブジェクトを取得.
     * @param name 対象の名前を設定します.
     * @return byte[] 対象のバイナリ情報が返されます.
     * @exception Exception 例外.
     */
    public synchronized byte[] getImage( String name )
        throws Exception {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "指定パスは不正です" ) ;
        }
        if( name.startsWith( "/" ) == false ) {
            name = "/" + name ;
        }
        if( name.endsWith( ".gif" ) == false ) {
            name += ".gif" ;
        }
        byte[] ret = cache.get( name ) ;
        if( ret == null ) {
            ret = FileUtil.getFileByResource( PATH + name ) ;
            if( ret == null ) {
                throw new IllegalArgumentException( "指定内容[" + name + "]は存在しません" ) ;
            }
            cache.put( name,ret ) ;
        }
        return ret ;
    }
    
}
