package org.maachang.proxy.engine.mobile.image.lib ;

import java.awt.image.BufferedImage;

/**
 * イメージ情報を確保するオブジェクト.
 *
 * @version 2007/11/29
 * @author  masahito suzuki
 * @since   MaachangProxy 1.00
 */
public class ImageInfo {
    
    /**
     * 画像情報.
     */
    private BufferedImage image = null ;
    
    /**
     * コンストラクタ.
     */
    public ImageInfo() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * イメージ情報を設定してオブジェクトを生成します.
     * <BR>
     * @param image 対象のイメージ情報を設定します.
     */
    public ImageInfo( BufferedImage image ) {
        this.setImage( image ) ;
    }
    
    /**
     * オブジェクトクリア.
     * <BR><BR>
     * オブジェクトをクリアします.
     */
    public void clear() {
        image = null ;
    }
    
    /**
     * イメージ情報を設定.
     * <BR><BR>
     * イメージ情報を設定します.
     * <BR>
     * @param image 対象のイメージ情報を設定します.
     */
    public void setImage( BufferedImage image ) {
        this.image = image ;
    }
    
    /**
     * イメージ情報を取得.
     * <BR><BR>
     * イメージ情報を取得します.
     * <BR>
     * @return BufferedImage 対象のイメージ情報が返されます.
     */
    public BufferedImage getImage() {
        return this.image ;
    }
    
    /**
     * Widthを取得.
     * <BR><BR>
     * 現在のイメージ情報に対するWidth情報を取得します.
     * <BR>
     * @return int Width情報が返されます.
     */
    public int getWidth() {
        if( this.image == null ) {
            return -1 ;
        }
        
        return image.getWidth() ;
    }
    
    /**
     * Heightを取得.
     * <BR><BR>
     * 現在のイメージ情報に対するHeight情報を取得します.
     * <BR>
     * @return int Height情報が返されます.
     */
    public int getHeight() {
        if( this.image == null ) {
            return -1 ;
        }
        
        return image.getHeight() ;
    }
    
    /**
     * オブジェクト有効チェック.
     * <BR><BR>
     * オブジェクトが有効であるかをチェックします.
     * <BR>
     * @return boolean オブジェクトが有効であるかを取得します.
     *                 [true]が返された場合、オブジェクトは有効です.
     *                 [false]が返された場合、オブジェクトは無効です.
     */
    public boolean isUse() {
        return ( this.image == null ) ? false : true ;
    }
    
}

