package org.maachang.proxy.engine.net.http;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * HTTPD-パラメータ群.
 *
 * @version 2007/08/20
 * @author  masahito suzuki
 * @since MaachangProxy 1.00
 */
public class HttpParams {
    
    /**
     * ヘッダ管理.
     */
    private HashMap<String,ArrayList<Object>> params = null ;
    
    /**
     * コンストラクタ.
     */
    public HttpParams() {
        
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        this.params = null ;
    }
    
    /**
     * パラメータ追加.
     * <BR><BR>
     * パラメータを追加します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param value 対象の要素を設定します.
     */
    public void add( String key,Object value ) {
        push( false,key,value ) ;
    }
    
    /**
     * パラメータ設定.
     * <BR><BR>
     * パラメータを設定します.<BR>
     * この条件で設定した場合、以前に登録したkeyに
     * 対する内容はクリアされます.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param value 対象の要素を設定します.
     */
    public void set( String key,Object value ) {
        push( true,key,value ) ;
    }
    
    /**
     * パラメータを追加／設定.
     */
    private void push( boolean mode,String key,Object value ) {
        Object val = null ;
        if( key == null ) {
            return ;
        }
        if( params == null ) {
            params = new HashMap<String,ArrayList<Object>>() ;
        }
        if( value == null ) {
            val = new NullObjectHeader() ;
        }
        else {
            val = value ;
        }
        if( mode == true ) {
            ArrayList<Object> lst = new ArrayList<Object>() ;
            lst.add( val ) ;
            params.put( key,lst ) ;
        }
        else {
            ArrayList<Object> lst = params.get( key ) ;
            if( lst == null ) {
                lst = new ArrayList<Object>() ;
                params.put( key,lst ) ;
            }
            lst.add( val ) ;
        }
    }
    
    /**
     * パラメータを削除.
     * <BR><BR>
     * 対象のパラメータを削除します.
     * <BR>
     * @param key 対象のキー名を設定します.
     */
    public void remove( String key ) {
        if( key == null || params == null ) {
            return ;
        }
        params.remove( key ) ;
    }
    
    /**
     * パラメータを削除.
     * <BR><BR>
     * 対象のパラメータを削除します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param no 対象の項番を設定します.
     */
    public void remove( String key,int no ) {
        if( key == null || params == null || no < 0 ) {
            return ;
        }
        ArrayList<Object> lst = params.get( key ) ;
        if( lst == null || lst.size() <= no ) {
            return ;
        }
        lst.remove( no ) ;
        if( lst.size() <= 0 ) {
            params.remove( key ) ;
        }
    }
    
    /**
     * パラメータを取得.
     * <BR><BR>
     * 対象のパラメータを取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return Object 対象の要素情報が返されます.
     */
    public Object get( String key ) {
        return get( key,0 ) ;
    }
    
    /**
     * パラメータを取得.
     * <BR><BR>
     * 対象のパラメータを取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param no 対象の項番を設定します.
     * @return Object 対象の要素情報が返されます.
     */
    public Object get( String key,int no ) {
        if( key == null || params == null || no < 0 ) {
            return null ;
        }
        ArrayList<Object> lst = params.get( key ) ;
        if( lst == null || lst.size() <= no ) {
            return null ;
        }
        Object ret = lst.get( no ) ;
        if( ret == null || ( ret instanceof NullObjectHeader ) ) {
            return null ;
        }
        return ret ;
    }
    
    /**
     * パラメータ数を取得.
     * <BR><BR>
     * 対象のパラメータ数を取得します.
     * <BR>
     * @return int パラメータ数が返されます.
     */
    public int size() {
        return ( params == null ) ? 0 : params.size() ;
    }
    
    /**
     * パラメータ数を取得.
     * <BR><BR>
     * 対象のパラメータ数を取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return int パラメータ数が返されます.
     */
    public int size( String key ) {
        if( key == null || params == null ) {
            return 0 ;
        }
        ArrayList<Object> lst = params.get( key ) ;
        if( lst == null ) {
            return 0 ;
        }
        return lst.size() ;
    }
    
    /**
     * キー名群を取得.
     * <BR><BR>
     * 対象のキー名群を取得します.
     * <BR>
     * @return String[] キー名群が返されます.
     */
    public String[] getKeys() {
        if( params == null || params.size() <= 0 ) {
            return null ;
        }
        Object[] keys = params.keySet().toArray() ;
        if( keys != null ) {
            int len = keys.length ;
            String[] ret = new String[ len ] ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret[ i ] = ( String )keys[ i ] ;
            }
            return ret ;
        }
        return null ;
    }
    
    /**
     * 指定キーが存在するかチェック.
     * <BR><BR>
     * 指定キーが存在するかチェックします.
     * <BR>
     * @param key 対象のキー名を取得します.
     * @return boolean [true]の場合、存在します.
     */
    public boolean isKey( String key ) {
        if( params == null ) {
            return false ;
        }
        return ( params.get( key ) == null ) ? false : true ;
    }
}

/**
 * NULL用オブジェクト.
 */
class NullObjectHeader {
    
}

