package org.maachang.proxy.engine.net.http;

import java.net.ServerSocket;

/**
 * サーバソケットインターフェイス.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since MaachangProxy 1.00
 */
public interface HttpServer {
    
    /**
     * オブジェクト破棄.
     */
    public void destroy() ;
    
    /**
     * アクセプト.
     * <BR><BR>
     * コネクションが存在する場合、HttpSocketが返されます.
     * <BR>
     * @return HttpSocket [null]の場合は、条件は存在しません.
     * @exception Exception 例外.
     */
    public HttpSocket accept() throws Exception ;
    
    /**
     * サーバオブジェクトを取得.
     * <BR>
     * @return ServerSocket サーバオブジェクトが返されます.
     */
    public ServerSocket serverSocket() ;
    
    /**
     * クローズチェック.
     * <BR>
     * @return [true]の場合、クローズしています.
     */
    public boolean isClosed() ;
    
}
