package org.maachang.proxy.engine.net.http;

/**
 * Accept用監視情報.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since MaachangProxy 1.00
 */
class NetAcceptThread extends Thread {
    
    private HttpServer server = null ;
    private NetSocketManager manager = null ;
    private volatile boolean stopFlag = true ;
    
    private NetAcceptThread() {
        
    }
    
    public NetAcceptThread( HttpServer server,NetSocketManager manager )
        throws Exception {
        this.server = server ;
        this.manager = manager ;
        this.stopFlag = false ;
        this.setDaemon( true ) ;
        this.start() ;
    }
    
    public void destroy() {
        setStop( true ) ;
    }
    
    public NetSocketManager getVtSocketManager() {
        return this.manager ;
    }
    
    public synchronized boolean isStop() {
        return stopFlag ;
    }
    
    private synchronized void setStop( boolean mode ) {
        this.stopFlag = mode ;
    }
    
    public void run() {
        boolean endFlag = false ;
        ThreadDeath threadDeach = null ;
        for( ;; ) {
            if( endFlag == true || isStop() == true ) {
                break ;
            }
            HttpSocket s = null ;
            try {
                if( ( s = server.accept() ) != null ) {
                    this.manager.append( s ) ;
                }
            } catch( InterruptedException ite ) {
                endFlag = true ;
            } catch ( NullPointerException ne ) {
            } catch( OutOfMemoryError mem ) {
            } catch( Exception e ) {
            } catch( ThreadDeath td ) {
                endFlag = true ;
                threadDeach = td ;
            }
        }
        this.server = null ;
        this.manager = null ;
        setStop( true ) ;
        if( threadDeach != null ) {
            throw threadDeach ;
        }
    }
    
}

