package org.maachang.proxy.engine.net.http;

import java.util.Vector;

/**
 * コネクション中ソケット管理.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since MaachangProxy 1.00
 */
class NetSocketManager {
    
    private Vector<HttpSocket> manager = null ;
    
    public NetSocketManager() {
        this.manager = new Vector<HttpSocket>() ;
    }
    
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    public void destroy() {
        if( this.manager != null ) {
            int len = this.manager.size() ;
            for( int i = 0 ; i < len ; i ++ ) {
                HttpSocket v = this.manager.get( i ) ;
                if( v != null ) {
                    v.destroy() ;
                }
            }
            this.manager = null ;
        }
    }
    
    public void append( HttpSocket v ) {
        if( isClosed() == true || v == null || v.isClosed() == true ) {
            return ;
        }
        this.manager.add( v ) ;
    }
    
    public HttpSocket get( int no ) {
        if( isClosed() == true || no < 0 || no >= this.manager.size() ) {
            return null ;
        }
        return this.manager.get( no ) ;
    }
    
    public void remove( int no ) {
        if( isClosed() == true || no < 0 || no >= this.manager.size() ) {
            return ;
        }
        this.manager.remove( no ) ;
    }
    
    public int size() {
        if( isClosed() == true ) {
            return 0 ;
        }
        return this.manager.size() ;
    }
    
    public boolean isClosed() {
        if( this.manager == null ) {
            return true ;
        }
        return false ;
    }
}
