package org.maachang.proxy.engine.net.http;

import java.util.LinkedList;

/**
 * 受信情報を保持したソケットオブジェクト管理キュー.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since MaachangProxy 1.00
 */
class NetUseQueue {
    private LinkedList<HttpSocket> queue = null ;
    
    public NetUseQueue() {
        queue = new LinkedList<HttpSocket>() ;
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    public synchronized void append( HttpSocket accept ) {
        if( queue == null || accept == null || accept.isClosed() == true ) {
            return ;
        }
        queue.add( accept ) ;
    }
    
    public synchronized HttpSocket getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
}
