package org.maachang.proxy.engine.net.server;

import org.maachang.proxy.engine.conf.ProxyOption;

/**
 * １つのプロキシ情報.
 * 
 * @version 2008/03/25
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class ProxyInfo {
    
    /** Proxy名 */
    private String name = null ;
    
    /** Proxy元URL. */
    private String url = null ;
    
    /** 接続先アドレス. */
    private String destUrl = null ;
    
    /** 接続ポート番号. */
    private int port = -1 ;
    
    /** サービス停止フラグ. */
    private boolean stopService = false ;
    
    /** PCアクセス許可フラグ. */
    private boolean accessPcFlag = true ;
    
    /** 携帯アクセス許可フラグ. */
    private boolean accessMobileFlag = true ;
    
    /** セッション名 */
    private String sessionName = null ;
    
    /** 接続先キャラクタセット. */
    private String charset = null ;
    
    /** サーバプーリング情報. */
    private HttpPoolingConnector httpPoolingConnector = null ;
    
    /**
     * コンストラクタ.
     */
    public ProxyInfo() {
        
    }
    
    /**
     * コンストラクタ.
     * @param option 対象のProxyオプションを設定します.
     * @exception Exception 例外.
     */
    public ProxyInfo( ProxyOption option )
        throws Exception {
        if( option == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        name = option.getName().trim().toLowerCase() ;
        url = option.getUrl() ;
        destUrl = option.getDestUrl() ;
        port = option.getPort() ;
        stopService = option.isStopService() ;
        accessPcFlag = option.isAccessPcFlag() ;
        accessMobileFlag = option.isAccessMobileFlag() ;
        sessionName = option.getSessionName() ;
        charset = option.getCharset() ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    /**
     * オブジェクト破棄.
     */
    protected void destroy() {
        try {
            this.stop() ;
        } catch( Exception e ) {
        }
        name = null ;
        url = null ;
        destUrl = null ;
        port = -1 ;
        httpPoolingConnector = null ;
        stopService = true ;
        accessPcFlag = true ;
        accessMobileFlag = true ;
        sessionName = null ;
        charset = null ;
    }
    
    /**
     * Proxyスタートアップ.
     * @exception Exception 例外.
     */
    public void startup() throws Exception {
        this.stop() ;
        new HttpPoolingConnector( this ) ;
    }
    
    /**
     * Proxy停止.
     * @exception Exception 例外.
     */
    public void stop() throws Exception {
        if( httpPoolingConnector != null ) {
            httpPoolingConnector.destroy() ;
        }
        httpPoolingConnector = null ;
    }
    
    /**
     * name を取得.
     * <BR><BR>
     * @return name が返されます.
     */
    public String getName() {
        return name;
    }
    
    /**
     * name を設定.
     * <BR><BR>
     * @param name name を設定します.
     */
    public void setName(String name) {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            this.name = null ;
        }
        else {
            this.name = name.trim();
        }
    }
    
    /**
     * destUrl を取得.
     * <BR><BR>
     * @return destUrl が返されます.
     */
    public String getDestUrl() {
        return destUrl;
    }
    
    /**
     * destUrl を設定.
     * <BR><BR>
     * @param destUrl destUrl を設定します.
     */
    public void setDestUrl(String destUrl) {
        this.destUrl = destUrl;
    }
    
    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() {
        return port;
    }
    
    /**
     * port を設定.
     * <BR><BR>
     * @param port port を設定します.
     */
    public void setPort(int port) {
        this.port = port;
    }
    
    /**
     * url を取得.
     * <BR><BR>
     * @return url が返されます.
     */
    public String getUrl() {
        return url;
    }
    
    /**
     * url を設定.
     * <BR><BR>
     * @param url url を設定します.
     */
    public void setUrl(String url) {
        this.url = url;
    }
    
    /**
     * stopService を取得.
     * <BR><BR>
     * @return stopService が返されます.
     */
    public boolean isStopService() {
        return stopService;
    }
    
    /**
     * stopService を設定.
     * <BR><BR>
     * @param stopService stopService を設定します.
     */
    public void setStopService(boolean stopService) {
        this.stopService = stopService;
    }
    
    /**
     * accessMobileFlag を取得.
     * <BR><BR>
     * @return accessMobileFlag が返されます.
     */
    public boolean isAccessMobileFlag() {
        return accessMobileFlag;
    }
    
    /**
     * accessMobileFlag を設定.
     * <BR><BR>
     * @param accessMobileFlag accessMobileFlag を設定します.
     */
    public void setAccessMobileFlag(boolean accessMobileFlag) {
        this.accessMobileFlag = accessMobileFlag;
    }
    
    /**
     * accessPcFlag を取得.
     * <BR><BR>
     * @return accessPcFlag が返されます.
     */
    public boolean isAccessPcFlag() {
        return accessPcFlag;
    }
    
    /**
     * accessPcFlag を設定.
     * <BR><BR>
     * @param accessPcFlag accessPcFlag を設定します.
     */
    public void setAccessPcFlag(boolean accessPcFlag) {
        this.accessPcFlag = accessPcFlag;
    }
    
    /**
     * sessionName を取得.
     * <BR><BR>
     * @return sessionName が返されます.
     */
    public String getSessionName() {
        return sessionName;
    }
    
    /**
     * sessionName を設定.
     * <BR><BR>
     * @param sessionName sessionName を設定します.
     */
    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }
    
    /**
     * charset を取得.
     * <BR><BR>
     * @return charset が返されます.
     */
    public String getCharset() {
        if( charset == null || ( charset = charset.trim() ).length() <= 0 ) {
            return "UTF8" ;
        }
        return charset;
    }
    
    /**
     * charset を設定.
     * <BR><BR>
     * @param charset charset を設定します.
     */
    public void setCharset(String charset) {
        this.charset = charset;
    }
    
    /**
     * HttpPoolingConnector を取得.
     * <BR><BR>
     * @return HttpPoolingConnector が返されます.
     */
    public HttpPoolingConnector getHttpPoolingConnector() {
        return httpPoolingConnector;
    }
    
    /**
     * HttpPoolingConnector を設定.
     * <BR><BR>
     * @param httpPoolingConnector httpPoolingConnector を設定します.
     */
    public void setHttpPoolingConnector(HttpPoolingConnector httpPoolingConnector) {
        this.httpPoolingConnector = httpPoolingConnector;
    }
    
    /**
     * オブジェクトが有効かチェック.
     * <BR>
     * @return boolean [true]の場合、有効です.
     */
    public boolean isUse() {
        return ( name != null &&
            url != null &&
            destUrl != null &&
            port > 0 ) ;
    }
    
    /**
     * ProxyOptionに変換.
     * @return ProxyOption ProxyOptionが返されます.
     */
    public ProxyOption getOption() {
        ProxyOption ret = new ProxyOption() ;
        ret.setDestUrl( destUrl ) ;
        ret.setName( name ) ;
        ret.setPort( port ) ;
        ret.setUrl( url ) ;
        ret.setStopService( stopService ) ;
        ret.setAccessPcFlag( accessPcFlag ) ;
        ret.setAccessMobileFlag( accessMobileFlag ) ;
        ret.setSessionName( sessionName ) ;
        ret.setCharset( charset ) ;
        return ret ;
    }
}
