package org.maachang.util;

/**
 * ID発行オブジェクト(同期版).
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class SequenceSync extends Sequence {

    /**
     * コンストラクタ. <BR>
     * <BR>
     * 任意の最大値を用いて情報を生成します.
     */
    public SequenceSync() {
        super();
    }

    /**
     * コンストラクタ. <BR>
     * <BR>
     * 情報を生成します. <BR>
     * 
     * @param start
     *            対象の開始値を設定します.
     * @param max
     *            管理を行うIDの幅(MAX値)を設定します.
     */
    public SequenceSync(int start, int max) {
        super(start, max);
    }

    /**
     * ファイナライズ処理定義. <BR>
     * <BR>
     * ファイナライズ処理定義.
     * 
     * @exception Exception
     *                例外処理が返されます.
     */
    protected void finalize() throws Exception {
        this.clear();
    }

    /**
     * 情報生成. <BR>
     * <BR>
     * 情報を生成します.
     */
    public synchronized void create() {
        super.create();
    }

    /**
     * 情報生成. <BR>
     * <BR>
     * 情報を生成します. <BR>
     * 
     * @param start
     *            対象の開始値を設定します.
     * @param max
     *            管理を行うIDの幅(MAX値)を設定します.
     * @exception InputException
     *                入力例外.
     */
    public synchronized void create(int start, int max) throws Exception {
        super.create(start, max);
    }

    /**
     * 情報クリア. <BR>
     * <BR>
     * 情報をクリアします.
     */
    public synchronized void clear() {
        super.clear();
    }

    /**
     * 一意なID項番を取得. <BR>
     * <BR>
     * 一意なID項番を取得します. <BR>
     * 
     * @return int 一意なID項番が返されます.
     */
    public synchronized int getId() {
        return super.getId();
    }

    /**
     * 次に発行するID情報を設定. <BR>
     * <BR>
     * 次に発行するID情報を設定します. <BR>
     * 
     * @param id
     *            次に発行されるID位置を設定します.
     */
    public synchronized void setNextId(int id) {
        super.setNextId(id);
    }

    /**
     * 設定ID開始番号の取得. <BR>
     * <BR>
     * 設定されているID開始番号を取得します. <BR>
     * 
     * @return int 設定されているID開始番号が返されます.
     */
    public synchronized int getStartId() {
        return super.getStartId();
    }

    /**
     * 設定ID幅(MAX値)を取得します. <BR>
     * <BR>
     * 設定されているID幅(MAX値)を取得します. <BR>
     * 
     * @return int 設定されているID幅(MAX値)が返されます.
     */
    public synchronized int getMaxID() {
        return super.getMaxID();
    }

    /**
     * カウント折り返し時の時間情報を取得. <BR>
     * <BR>
     * カウントが設定ID幅(MAX値)を折り返したときの時間を取得します. <BR>
     * 
     * @return long 折り返し時間が返されます.
     */
    public synchronized long getReturnIDByTime() {
        return super.getReturnIDByTime();
    }

}
