package org.maachang.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 処理時間を保持する.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class TimerPrint {
    private static final Log LOG = LogFactory.getLog( TimerPrint.class ) ;
    private long time = -1L ;
    private long wait = -1L ;
    public TimerPrint() {
        time = -1L ;
        wait = -1L ;
    }
    public String start() {
        String ret = toString() ;
        time = System.currentTimeMillis() ;
        wait = -1L ;
        return ret ;
    }
    public long stop() {
        if( time <= -1L ) {
            wait = -1L ;
            return -1L ;
        }
        wait = System.currentTimeMillis() - time ;
        return wait ;
    }
    public long get() {
        return wait ;
    }
    public String toString() {
        if( wait <= -1L ) {
            return " not wait" ;
        }
        return new StringBuilder().append( "- {{" ).append( wait ).
            append( "}}ms" ).toString() ;
    }
    public void println( String string ) {
        if( string == null ) {
            System.out.println( toString() ) ;
        }
        else {
            System.out.println( string + toString() ) ;
        }
    }
    
    public void debug( String string ) {
        if( LOG.isDebugEnabled() ) {
            if( string == null ) {
                LOG.debug( toString() ) ;
            }
            else {
                LOG.debug( string + toString() ) ;
            }
        }
    }

}
