package org.maachang.util.conf ;

import java.net.InetAddress;

/**
 * 文字パラメータをコンバート.
 * 
 * @version 2008/01/18
 * @author masahito suzuki
 * @since MaachangProxy 1.00
 */
public class ConvIniParam {
    /**
     * 指定情報をBoolean値に変換.
     * <BR><BR>
     * 指定情報をBoolean値に変換します.
     * <BR>
     * @param data 対象のデータを設定します.
     * @return Boolean 変換された内容が返されます.
     */
    public static final boolean getBoolean( String data ) {
        boolean ret = false ;
        if( data != null && ( data = data.trim() ).length() > 0 ) {
            data = data.toLowerCase() ;
            if( data.equals( "true" ) || data.equals( "on" ) || data.equals( "ok" ) ) {
                ret = true ;
            }
        }
        return ret ;
    }
    
    /**
     * 指定情報をInt値に変換.
     * <BR><BR>
     * 指定情報をInt値に変換します.
     * <BR>
     * @param data 対象のデータを設定します.
     * @return int 変換された内容が返されます.
     */
    public static final int getInt( String data ) {
        int ret = -1 ;
        if( data != null && ( data = data.trim() ).length() > 0 ) {
            try {
                ret = Integer.parseInt( data ) ;
            } catch( Exception e ) {
                ret = -1 ;
            }
        }
        return ret ;
    }
    
    /**
     * 指定情報をLong値に変換.
     * <BR><BR>
     * 指定情報をLong値に変換します.
     * <BR>
     * @param data 対象のデータを設定します.
     * @return long 変換された内容が返されます.
     */
    public static final long getLong( String data ) {
        long ret = -1L ;
        if( data != null && ( data = data.trim() ).length() > 0 ) {
            try {
                ret = Long.parseLong( data ) ;
            } catch( Exception e ) {
                ret = -1L ;
            }
        }
        return ret ;
    }
    
    /**
     * 指定情報をDouble値に変換.
     * <BR><BR>
     * 指定情報をDouble値に変換します.
     * <BR>
     * @param data 対象のデータを設定します.
     * @return double 変換された内容が返されます.
     */
    public static final double getDouble( String data ) {
        double ret = -1.0f ;
        if( data != null && ( data = data.trim() ).length() > 0 ) {
            try {
                ret = Double.parseDouble( data ) ;
            } catch( Exception e ) {
                ret = -1.0f;
            }
        }
        return ret ;
    }
    
    /**
     * 指定情報をInetAddressに変換.
     * <BR><BR>
     * 指定情報をInetAddressに変換します.
     * <BR>
     * @param data 対象のデータを設定します.
     * @return long 変換された内容が返されます.
     */
    public static final InetAddress getInetAddress( String data ) {
        InetAddress ret = null ;
        if( data != null && ( data = data.trim() ).length() > 0 ) {
            try {
                ret = InetAddress.getByName( data ) ;
            } catch( Exception e ) {
                ret = null ;
            }
        }
        return ret ;
    }
}
