/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.pool;

import java.io.IOException;
import org.maachang.dao.dbms.pool.OnePoolManager;
import org.maachang.dao.dbms.pool.PoolConnection;

class PoolThread
extends Thread {
    private static final long SLEEP_TIME = 5000L;
    private static final long MIN_TIME = 60000L;
    private static final long MAX_TIME = 1800000L;
    private static final long DEF_TIME = 300000L;
    private long deleteTime = -1L;
    private OnePoolManager factory = null;
    private Object sync = null;
    private volatile boolean exitFlag = false;

    private PoolThread() {
    }

    public PoolThread(OnePoolManager factory) throws IllegalArgumentException, IOException {
        this(300000L, factory);
    }

    public PoolThread(long time, OnePoolManager factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (time <= 60000L) {
            time = 60000L;
        } else if (time >= 1800000L) {
            time = 1800000L;
        }
        this.deleteTime = time;
        this.factory = factory;
        this.exitFlag = false;
        this.sync = factory.getSync();
        this.start();
    }

    protected final void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            this.exitFlag = true;
        }
        this.deleteTime = -1L;
        this.factory = null;
        this.sync = null;
    }

    public long getDeleteTime() {
        return this.deleteTime;
    }

    public boolean isThread() {
        return this.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean stopFlag = false;
        while (!stopFlag) {
            this.execution();
            Object object = this.sync;
            synchronized (object) {
                if (this.exitFlag) {
                    stopFlag = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void execution() {
        PoolConnection[] cons = null;
        PoolConnection con = null;
        try {
            long tm;
            Thread.sleep(5000L);
            Object object = this.sync;
            synchronized (object) {
                tm = this.deleteTime;
                cons = this.factory.getArrays();
            }
            int len = cons.length;
            int i = 0;
            while (i < len) {
                block18: {
                    Thread.sleep(30L);
                    object = this.sync;
                    synchronized (object) {
                        con = cons[i];
                        if (con == null) {
                            break block18;
                        }
                        Object object2 = con.getSync();
                        synchronized (object2) {
                            if (!con.isUse() && con.getLastAccessTime() + tm < System.currentTimeMillis()) {
                                con = null;
                                cons[i] = null;
                            }
                        }
                        con = null;
                    }
                }
                ++i;
            }
        }
        catch (InterruptedException ie) {
            Object object = this.sync;
            synchronized (object) {
                this.exitFlag = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

