// 基本スクリプト.
//

////////////////////////////////////////////////////////////////////////////////
// ScriptContextScope定義.
////////////////////////////////////////////////////////////////////////////////
var ENGINE_SCOPE = 100 ;
var GLOBAL_SCOPE = 200 ;

////////////////////////////////////////////////////////////////////////////////
// path系.
////////////////////////////////////////////////////////////////////////////////

// 現在読み込みスクリプト名を取得.
currentName = function() {
    return _$current$name ;
} ;

// カレントパスを取得.
currentPath = function() {
    return _$path$currentPath ;
} ;

// スクリプトパスを取得.
scriptPath = function() {
    return _$path$scriptPath ;
} ;

// モデルパスを取得.
modelPath = function() {
    return _$path$modelPath ;
} ;


////////////////////////////////////////////////////////////////////////////////
// 基本系.
////////////////////////////////////////////////////////////////////////////////

// maachangCometバージョン取得.
version = function() {
    return org.maachang.comet.httpd.HttpdVersionDef.getVersion()
} ;

// maachangComet更新日取得.
update = function() {
    return org.maachang.comet.httpd.HttpdVersionDef.getDate() ;
} ;

// データベースが利用可能かチェック.
isDatabase = function() {
    if( _$$maachang_comet_manager.get( "DBMS_POOL" )  == null ) {
        return false ;
    }
    return true ;
}

// bindingsを取得.
bindings = function(scope) {
    if( isNull( _$script$context ) ) {
        return null ;
    }
    if( isNull( scope ) ) {
        scope = ENGINE_SCOPE ;
    }
    return _$script$context.getBindings( scope ) ;
}

// スクリプトキャッシュリロード.
reload = function() {
    org.maachang.comet.httpd.engine.script.cache.CacheScriptManager.getInstance().reload() ;
} ;

// スクリプトタイプを取得.
getScriptType = function() {
    if( isNull( __$type$script ) ) {
        return null ;
    }
    return __$type$script ;
} ;

// スクリプト詳細を取得.
getScriptDetail = function() {
    if( isNull( __$detail$script ) ) {
        return null ;
    }
    return __$detail$script ;
} ;

// eval実装用をセット.
_eval = function(script){
    if( isNull( _$script$context ) ) {
        return null ;
    }
    if( isNull( script ) || isNull( _$script$engine ) ) {
        return null ;
    }
    return _$script$engine.eval(script,_$script$context ) ;
} ;
eval = function( script ) {
    return _eval( script ) ;
} ;

// スクリプト強制終了用.
_exit = function(result){
    if( isNull( result ) ) {
        result = null ;
    }
    _$_$exit$of$result$_$_ = result ;
    org.maachang.comet.httpd.engine.script.EndScript.exit() ;
} ;
exit = function(result){
    _exit(result) ;
} ;

// Bindingsセット.
putBindings = function( key,value ) {
    if( isNull( _$script$context ) ) {
        return ;
    }
    if( useString( key ) == true && isNull( value ) == false ) {
        _$script$context.getBindings( ENGINE_SCOPE ).put( key,value ) ;
    }
}

// Bindings削除.
removeBindings = function( key ) {
    if( isNull( _$script$context ) ) {
        return ;
    }
    if( useString( key ) == true ) {
        _$script$context.getBindings( ENGINE_SCOPE ).remove( key ) ;
    }
}

// Bindings取得.
getBindings = function( key ) {
    if( isNull( _$script$context ) ) {
        return null ;
    }
    if( useString( key ) == true ) {
        return _$script$context.getBindings( ENGINE_SCOPE ).get( key ) ;
    }
    return null ;
}

// 指定内容タイプを取得.
valueof = function( val ) {
    if( isNull( val ) ) {
        return "null" ;
    }
    var t = typeof( val ) ;
    var clz = className( val ) ;
    if( t == "string" || clz == "String" ) {
        return "string" ;
    }
    if( t == "boolean" || clz == "Boolean" ) {
        return "boolean" ;
    }
    if( t == "number" && isNumeric( val ) == true ) {
        return "number" ;
    }
    if( t == "function" ) {
        if( clz == "JSAdapter" ) {
            return arrayOrMapValueTo( val ) ;
        }
        return "function" ;
    }
    if( t == "object" ) {
        if( clz == "JSAdapter" ) {
            return arrayOrMapValueTo( val ) ;
        }
        if( clz == "NativeArray" ) {
            return "array" ;
        }
        if( clz == "NativeObject" ) {
            return arrayOrMapValueTo( val ) ;
        }
        if( clz == "NativeDate" ) {
            return "date" ;
        }
        if( isBinary( val ) == true ) {
            return "binary" ;
        }
    }
    return "object" ;
}

// 指定内容タイプがArrayかMapか取得.
arrayOrMapValueTo = function( val ) {
    var cnt = 0 ;
    var aryFlg = true ;
    for( var k in val ) {
        if( cnt != k ) {
            cnt ++ ;
            aryFlg = false ;
            break ;
        }
        cnt ++ ;
    }
    if( cnt == 0 ) {
        return "object" ;
    }
    if( aryFlg == true ) {
        return "array" ;
    }
    return "map" ;
}

// jmap.
jmap = function(map) {
    if( isNull( map ) ) {
        map = new java.util.HashMap() ;
    }
    return new JSAdapter({
        __get__ : function(name) {
            if (map.containsKey(name)) {
                var ret = map.get(name) ;
                return parseValue( ret ) ;
            }
            else if( name == "toString" ) {
                var ret = "{" ;
                var o = map.keySet().toArray() ;
                if( o != null && o.length > 0 ) {
                    var len = o.length ;
                    var cnt = 0 ;
                    for( var i = 0 ; i < len ; i ++ ) {
                        var x = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
                        if( cnt != 0 ) {
                            ret += " ," ;
                        }
                        var v = map.get( x ) ;
                        if( v != null ) {
                            if( className( v ) == "JSAdapter" ) {
                                ret += x + ": " + "\""+v.toString+"\"" ;
                            }
                            else {
                                ret += x + ": " + "\""+v+"\"" ;
                            }
                        }
                        else {
                            ret += x + ": \"\"" ;
                        }
                        cnt ++ ;
                    }
                }
                ret += "}" ;
                return ret ;
            }
            else if( name == "length" ) {
                var ret = map.size() ;
                if( isNull( ret ) == true ) {
                    return null ;
                }
                else if( useString( ret ) == false ) {
                    return "" ;
                }
                return parseValue(ret) ;
            }
            else {
                return "";
            }
          },
        __has__ :  function(name) {
                if( name == 'length' || name == 'toString' ) {
                    return true ;
                }
                return map.containsKey(name);
            },
        __delete__ : function (name) {
                return map.remove(name);
            },
        __put__ : function(name, value) {
                map.put(name, value);
            },
        __getIds__ : function() {
                var ret = [] ;
                var o = map.keySet().toArray() ;
                var len = o.length ;
                for( var i = 0 ; i < len ; i ++ ) {
                    var one = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
                    ret[ i ] = one ;
                }
                return ret ;
            },
        toString: function() {
            var ret = "{" ;
            var it = map.keySet().iterator() ;
            var cnt = 0 ;
            for( var x = it.next() ;it.hasNext() ; x = it.next() ) {
                if( cnt != 0 ) {
                    ret += " ," ;
                }
                var v = map.get( x ) ;
                if( v != null ) {
                    if( className( v ) == "JSAdapter" ) {
                        ret += x + ": " + "\""+v.toString+"\"" ;
                    }
                    else {
                        ret += x + ": " + "\""+v+"\"" ;
                    }
                }
                else {
                    ret += x + ": \"\"" ;
                }
                cnt ++ ;
            }
            ret += "}" ;
            return ret ;
        },
        length: function() {
            var ret = map.size() ;
            if( isNull( ret ) == true ) {
                return null ;
            }
            else if( useString( ret ) == false ) {
                return "" ;
            }
            return parseValue(ret) ;
        }
    });
} ;

// jlist.
jlist = function(list) {
    if( isNull( list ) ) {
        list = new java.util.ArrayList() ;
    }
    function isValid(index) {
        return typeof(index) == 'number' &&
            index > -1 && index < list.size();
    }
    return new JSAdapter({
        __get__ :  function(name) {
            if( name == "toString" ) {
                var ret = "[" ;
                var len = list.size() ;
                var cnt = 0 ;
                for (var i = 0; i < len; i++) {
                    var v = list.get( i ) ;
                    if( v != null ) {
                        if( cnt != 0 ) {
                            ret += "," ;
                        }
                        if( className( v ) == "JSAdapter" ) {
                            ret += v.toString ;
                        }
                        else {
                            ret += v ;
                        }
                        cnt ++ ;
                    }
                }
                ret += "]" ;
                return ret;
            }
            else if( name == "length" ) {
                var ret = list.size() ;
                if( isNull( ret ) == true ) {
                    return null ;
                }
                else if( useString( ret ) == false ) {
                    return "" ;
                }
                else if( className( ret ) == "NativeDate" ) {
                    return ret ;
                }
                return parseValue(ret) ;
            }
            else if (isValid(name)) {
                var ret = list.get(name);
                return parseValue( ret ) ;
            }
            else {
                return null;
            }
        },
        __has__ : function (name) {
            return isValid(name) || name == 'length' || name == 'toString';
        },
        __delete__ : function(name) {
            if (isValid(name)) {
                list.remove(name);
            }
        },
        __put__ : function(name, value) {
            if (isValid(name)) {
                list.set(name, value);
            }
        },
        __getIds__: function() {
            var res = new Array(list.size());
            for (var i = 0; i < res.length; i++) {
                res[i] = i;
            }
            return res;
        },
        toString: function() {
            var ret = "[" ;
            var len = list.size() ;
            var cnt = 0 ;
            for (var i = 0; i < len; i++) {
                var v = list.get( i ) ;
                if( v != null ) {
                    if( cnt != 0 ) {
                        ret += "," ;
                    }
                    if( className( v ) == "JSAdapter" ) {
                        ret += v.toString ;
                    }
                    else {
                        ret += v ;
                    }
                    cnt ++ ;
                }
            }
            ret += "]" ;
            return ret;
        },
        length: function() {
            var ret =list.size() ;
            if( isNull( ret ) == true ) {
                return null ;
            }
            else if( useString( ret ) == false ) {
                return "" ;
            }
            return parseValue(ret) ;
        }
    });
} ;

// ガページコレクターを実行.
gc = function() {
    java.lang.Runtime.getRuntime().gc() ;
} ;

// トータルメモリを取得.
mtotal = function() {
    return java.lang.Runtime.getRuntime().totalMemory() ;
} ;

// 最大メモリを取得.
mmax = function() {
    return java.lang.Runtime.getRuntime().maxMemory() ;
} ;

// 空きメモリを取得.
mfree = function() {
    return java.lang.Runtime.getRuntime().freeMemory() ;
} ;

// タイプに合わせて内容を変換.
parseValue = function( value ) {
    if( isNull( value ) ) {
        return null ;
    }
    var t = valueof( value ) ;
    if( t == "number" || t == "string" ) {
        var x = ( "" + value ).toLowerCase() ;
        if( x == "true" || x == "false" ) {
            if( x == "true" ) {
                return true ;
            }
            return false ;
        }
        if( isNumeric( value ) == true ) {
            //if( isDouble( value ) == false ) {
            //    return java.lang.Integer.parseInt(value);
            //}
            return parseInt(""+value) ;
        }
    }
    else if( t == "object" ) {
        var clz = className( value ) ;
        if( clz == 'Short' || clz == 'Integer' ||
            clz == 'Long' || clz == 'Double' ||
            clz == 'Float' ) {
            //if( isDouble( value ) == false ) {
            //    return java.lang.Integer.parseInt(value);
            //}
            value = parseInt(""+value) ;
        }
    }
    return value ;
} ;

// NULLデータ判別.
isNull = function( value ) {
    if( value == null || typeof( value ) == "undefined" ) {
        return true ;
    }
    return false ;
} ;

// 数値チェック.
isNumeric = function(num){
    if( isNull( num ) ) {
        return false ;
    }
    num = ""+num ;
    if( useString( num ) == false ) {
        return false ;
    }
    if( startsWith( num,"-" ) ) {
        num = num.substring( 1 ) ;
    }
    if (num.match(/[^0-9.0-9]/g)) {
        return false;
    }
    return true;
} ;

// 数値(小数点)チェック.
isDouble = function(num){
    if( isNull( num ) ) {
        return false ;
    }
    num = ""+num ;
    if( useString( num ) == false ) {
        return false ;
    }
    if( startsWith( num,"-" ) ) {
        num = num.substring( 1 ) ;
    }
    if( num.match(/[^0-9]/g) ) {
        return false ;
    }
    else if (num.match(/[^0-9.0-9]/g)) {
        return true;
    }
    return false ;
} ;


// 文字列が存在するかチェック.
useString = function(str){
    if( isNull( str ) ) {
        return false ;
    }
    if( trim( ""+str ).length <= 0 ) {
        return false ;
    }
    return true ;
} ;

// 指定内容をプリミティブ型に変換.
convertPrimitive = function(type,value) {
    if( isNull( type ) || isNull( value ) ) {
        return null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.convertPrimitive( type,value ) ;
} ;

// 指定オブジェクトのクラス名を取得.
objectClassName = function( obj ) {
    if( isNull( obj ) ) {
        return null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.objectClassName( obj ) ;
} ;

// 指定オブジェクト名の名前を取得.
className = function( obj ) {
    var ret = objectClassName( obj ) ;
    if( ret == null ) {
        return null ;
    }
    var p = ret.lastIndexOf( "." ) ;
    if( p != -1 ) {
        return ret.substring( p+1 ) ;
    }
    return ret ;
} ;

// wait時間をセット.
sleep = function(time) {
    if( isNull( time ) ) {
        return ;
    }
    java.lang.Thread.sleep( time );
} ;

// alert偽造.
alert = function(str){
    println( str );
} ;

// println偽造.
p = function(str){
    println( str ) ;
} ;

// println偽装.
puts = function(str) {
    println( str ) ;
} ;

// Javaオブジェクト配列長を取得.
arrayLength = function(objs) {
    if( isNull( objs ) ) {
        return -1 ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.arrayLength( objs ) ;
} ;

// javaオブジェクト配列の指定位置情報を取得.
getArray = function(objs,no) {
    if( isNull( objs ) || isNull( no ) ) {
        return null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.getArray( objs,no ) ;
} ;

// javaオブジェクト配列の指定位置情報を取得.
setArray = function(objs,no,value) {
    if( isNull( objs ) || isNull( no ) || isNull( value ) ) {
        return null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.setArray( objs,no,value ) ;
} ;

// 指定文字列をバイナリに変換.
convertStringByBinary = function( string,charset ) {
    if( isNull( string ) ) {
        string = null ;
    }
    if( isNull( charset ) ) {
        charset = null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.convertStringByBinary( string,charset ) ;
} ;

// 指定バイナリを文字列に変換.
convertBinaryByString = function( binary,charset ) {
    if( isNull( binary ) ) {
        binary = null ;
    }
    if( isNull( charset ) ) {
        charset = null ;
    }
    return ""+org.maachang.comet.httpd.engine.script.js.JsDef.convertBinaryByString( binary,charset ) ;
} ;

// 新しいバイナリ情報を生成.
createBinary = function( size ) {
    return org.maachang.comet.httpd.engine.script.js.JsDef.createBinary( size ) ;
} ;

// バイナリ内容を表示形式に変換.
toBinaryString = function( binary ) {
    if( isNull( binary ) ) {
        binary = null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.toBinaryString( binary ) ;
} ;

// バイナリ長を取得.
binaryLength = function(objs) {
    if( isNull( objs ) ) {
        return -1 ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.binaryLength( objs ) ;
} ;

// バイナリの情報を取得.
getBinary = function(objs,no) {
    if( isNull( objs ) || isNull( no ) ) {
        return null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.getBinary( objs,no ) ;
} ;


// バイナリ情報に設定.
setBinary = function(objs,no,value) {
    if( isNull( value ) ) {
        return null ;
    }
    if( typeof( value ) == 'number' ) {
        return org.maachang.comet.httpd.engine.script.js.JsDef.setBinaryByByte( objs,no,value ) ;
    }
    value = new java.lang.String( ""+value ) ;
    return org.maachang.comet.httpd.engine.script.js.JsDef.setBinary( objs,no,value ) ;
} ;

// バイナリ情報かチェック.
isBinary = function( value ) {
    if( isNull( value ) ) {
        return false ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.isBinary( value ) ;
} ;

// Base64エンコード.
encodeBase64 = function(binary){
    if( isNull( binary ) ) {
        return null ;
    }
    return org.maachang.util.Base64.encode(binary);
} ;

// Base64デコード.
decodeBase64 = function(str){
    if( isNull( str ) ) {
        return null ;
    }
    return org.maachang.util.Base64.decode(str);
} ;

// trim.
trim = function(str){
    if( isNull( str ) ) {
        return null ;
    }
    var tof = typeof(str) ;
    if( tof == "object" ) {
        if( str instanceof String ) {
            return ""+str.trim() ;
        }
    }
    else if( tof == "string" ) {
        var t = java.lang.String(str);
        t = t.trim() ;
        return ""+t ;
    }
    return str ;
} ;

// toLowerCase.
toLowerCase = function(str){
    if( isNull( str ) ) {
        return null ;
    }
    str = ""+str ;
    return str.toLowerCase() ;
} ;

// toUpperCase.
toUpperCase = function(str){
    if( isNull( str ) ) {
        return null ;
    }
    str = ""+str ;
    return str.toUpperCase() ;
} ;

// startWith.
startsWith = function(str,chk) {
    if( isNull( str ) || isNull( chk ) ) {
        return false ;
    }
    str = ""+str ;
    chk = ""+chk ;
    if( str.indexOf( chk ) == 0 ) {
        return true ;
    }
    return false ;
} ;

// endsWith.
endsWith = function(str,chk) {
    if( isNull( str ) || isNull( chk ) ) {
        return false ;
    }
    str = ""+str ;
    chk = ""+chk ;
    var last = str.lastIndexOf( chk ) ;
    if( last != -1 && last == str.length-chk.length ) {
        return true ;
    }
    return false ;
} ;

// 指定文字列を置き換える.
changeString = function(str,src,dest) {
    return ""+org.maachang.util.StringUtil.changeString( str,src,dest ) ;
}

// 指定フォーマットに対して文字列から数値変換(simpleDateFormat).
dateParse = function(format,value) {
    if( isNull( format ) || isNull( value ) ) {
        return null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.convertDateFormatByString( format,value ) ;
} ;

// 指定フォーマットに対して数値から文字列変換(simpelDateFormat).
dateFormat = function(format,value) {
    var tm = dateParse( format,value ) ;
    if( tm == null ) {
        return null ;
    }
    return new Date().setTime( tm ) ;
} ;

// 現在日付を取得.
dateToString = function( mode ) {
    return formatDateByString( new Date(),mode )
} ;

// 現在日付を取得.
date = function() {
    println( dateToString() ) ;
} ;

// 日付を変換.
formatDateByString = function( date,mode ) {
    if( isNull( date ) ) {
        return null ;
    }
    if( isNull( mode ) ) {
        mode = false ;
    }
    var ret = "" + date.getFullYear() ;
    var x = ""+(date.getMonth()+1) ;
    ret += "/" + "00".substring( x.length,2 ) + x ;
    x = ""+date.getDate() ;
    ret += "/" + "00".substring( x.length,2 ) + x ;
    if( __$type$script == "console" ) {
        ret += " " ;
    }
    else {
        if( mode == true ) {
            ret += "&nbsp;" ;
        }
        else {
            ret += " " ;
        }
    }
    x = ""+date.getHours() ;
    ret += "00".substring( x.length,2 ) + x ;
    x = ""+date.getMinutes() ;
    ret += ":" + "00".substring( x.length,2 ) + x ;
    x = ""+date.getSeconds() ;
    ret += ":" + "00".substring( x.length,2 ) + x ;
    return ret ;
} ;

// 指定ドメインのIPアドレスを取得.
ip = function(name) {
    if( isNull( name ) ) {
        return ;
    }
    var addrs = java.net.InetAddress.getAllByName(name);
    for (var i in addrs) {
        println(addrs[i]);
    }
} ;

// 指定ドメインのIPアドレスを取得.
convertDomainToIp = function(name) {
    if( isNull( name ) ) {
        return [] ;
    }
    var addrs = java.net.InetAddress.getAllByName(name);
    var ret = [] ;
    var cnt = 0 ;
    for (var i in addrs) {
        ret[ cnt ] = addrs[i];
        cnt ++ ;
    }
    return ret ;
} ;

// HTMLに対して表示可能な形式に変換.
convertViewHtml = function(string) {
    if( useString( string ) == false ) {
        return "" ;
    }
    else if( valueof(string) != "string" ) {
        return string ;
    }
    return ""+org.maachang.comet.httpd.engine.script.js.JsDef.convertByViewHtml( true,string ) ;
} ;

// 動的なHTMLタグを含む条件かチェック.
isDirectHtmlTag = function(string) {
    if( useString( string ) == false ) {
        return false ;
    }
    else if( valueof(string) != "string" ) {
        return false ;
    }
    return org.maachang.comet.httpd.engine.script.js.ConvertTag.isTag( string ) ;
} ;

// 動的なHTMLタグを表示可能な形式に変換.
convertDirectHtml = function(string) {
    if( useString( string ) == false ) {
        return "" ;
    }
    else if( valueof(string) != "string" ) {
        return string ;
    }
    return ""+org.maachang.comet.httpd.engine.script.js.ConvertTag.convert( string ) ;
} ;

// 指定文字列の全角内容を半角変換.
convertZenToHan = function(string) {
    if( useString( string ) == false ) {
        return "" ;
    }
    else if( valueof(string) != "string" ) {
        return string ;
    }
    return ""+org.maachang.util.ZenToHan.convertHankaku( string ) ;
}

// 指定コンフィグ内容を取得.
getConfig = function( section,key,no ) {
    var conf = null ;
    if( ( conf = _$$maachang_comet_manager.get( "CONFIG_MANAGER" ) )  == null ) {
        return null ;
    }
    if( useString( section ) == false || useString( key ) == false ) {
        return null ;
    }
    if( isNumeric( no ) == false ) {
        no = 0 ;
    }
    return conf.get( section,key,no ) ;
} ;


// 文字列連結オブジェクト.
StrBuf = function() {}
StrBuf.prototype = {
    // buffer.
    buf: null,
    // 生成処理.
    create: function(len) {
        if( isNull( len ) || typeof(len) != "number" || len <= 0 ) {
            this.buf = new java.lang.StringBuilder() ;
        }
        else {
            this.buf = new java.lang.StringBuilder(len) ;
        }
    },
    // クリア処理.
    clear: function() {
        this.buf = null ;
    },
    // 連結.
    append: function(str) {
        if( isNull( str ) ) {
            return ;
        }
        if( this.buf == null ) {
            this.create() ;
        }
        this.buf.append( ""+str ) ;
        return this ;
    },
    // 長さを取得.
    length: function() {
        if( this.buf == null ) {
            return 0 ;
        }
        return this.buf.length() ;
    },
    // 内容表示.
    toString: function() {
        return this.toBuffer() ;
    },
    // 連結情報出力.
    toBuffer: function() {
        if( this.buf == null ) {
            return null ;
        }
        return ""+this.buf.toString() ;
    }
} ;

// ネットマスクオブジェクト.
NetMask = function() {}
NetMask.prototype = {
    object: null,
    create: function( addr,mask ) {
        if( useString( addr ) == false ) {
            return false ;
        }
        if( isNull( mask ) ) {
            this.object = new org.maachang.util.NetMask( addr ) ;
        }
        else {
            this.object = new org.maachang.util.NetMask( addr,mask ) ;
        }
        return true ;
    },
    clear: function() {
        this.object = null ;
    },
    getNetworkAddress: function() {
        if( isNull( this.object ) ) {
            return null ;
        }
        return this.object.getNetworkAddress() ;
    },
    getNetMask: function() {
        if( isNull( this.object ) ) {
            return null ;
        }
        return this.object.getNetMask() ;
    },
    isRange: function( addr ) {
        if( isNull( this.object ) || useString( addr ) == false ) {
            return false ;
        }
        return this.object.isRange( addr ) ;
    }
} ;

