///////////////////////////////////////////////////////////////////////////////
// shogi-operate.js
// Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// 将棋盤操作用オブジェクト.
////////////////////////////////////////////////////////////////////////////////

// 将棋操作処理.
OperateShogi = function() {}
OperateShogi.prototype = {
    
    // 将棋盤表示用オブジェクト.
    viewBord: null,
    // 処理タイプ(trueの場合、上の駒だけが選択可能
    //            falseの場合、下の駒だけが選択可能
    //            [null]の場合、全選択可能.
    type: null,
    // 将棋盤クリックカラー.
    bordClickColor: "#ff0000",
    // 将棋盤マウスオーバカラー.
    bordOverColor: "#00ff7f",
    // 保有駒クリックカラー.
    posClickColor: "#0000ff",
    // 保有駒クリックカラー.
    posOverColor: "#7f7f7f",
    // 前回将棋盤クリック位置.
    bef_click_map: null,
    // 前回将棋盤マウスオーバ位置.
    bef_over_map: null,
    // 前回保有駒クリック位置.
    bef_click_pos: null,
    // 前回保有駒マウスオーバ位置.
    bef_over_pos: null,
    // 成り駒選択時のメッセージ.
    message_select_nari: "成りますか?",
    
    // 初期化処理.
    init: function( type,viewBord,bordClickColor,bordOverColor,posClickColor,posOverColor,message_select_nari ) {
        if( isNull( viewBord ) ) {
            return ;
        }
        this.viewBord = viewBord ;
        if( isNull( type ) ) {
            type = null ;
        }
        this.type = type ;
        if( isNull( bordClickColor ) == false ) {
            this.bordClickColor = bordClickColor ;
        }
        if( isNull( bordOverColor ) == false ) {
            this.bordOverColor = bordOverColor ;
        }
        if( isNull( posClickColor ) == false ) {
            this.posClickColor = posClickColor ;
        }
        if( isNull( posOverColor ) == false ) {
            this.posOverColor = posOverColor ;
        }
        if( isNull( message_select_nari ) == false ) {
            this.message_select_nari = message_select_nari ;
        }
    },
    // 将棋盤クリック処理.
    // 駒を打った場合は[true]が返されます.
    click_map: function( x,y ) {
        // 以前に選択されている.
        if( this.bef_click_map != null ) {
            this.clear_view_map_click( true ) ;
            // 同一位置が選択されている.
            if( x == this.bef_click_map[ 0 ] && y == this.bef_click_map[ 1 ] ) {
                this.bef_click_map = null ;
                return false ;
            }
            var ret = false ;
            // 前回座標に有効な駒が選択されている(移動).
            if( this.viewBord.isUseKomaXY( this.bef_click_map[0],this.bef_click_map[1] ) == true ) {
                var mode = this.viewBord.isUpKomaXY( this.bef_click_map[0],this.bef_click_map[1] ) ;
                // 移動先は味方の駒ではない.
                if( ( mode != this.viewBord.isUpKomaXY( x,y ) || this.viewBord.isUseKomaXY( x,y ) == false ) &&
                    this.viewBord.isMoveKoma( this.bef_click_map[0],this.bef_click_map[1],x,y ) == true ) {
                    var nariMode = false ;
                    // ターゲットの駒が成れる場合.
                    if( ( this.viewBord.isBordByNari( mode,x,y ) == true ||
                            this.viewBord.isBordByNari( mode,this.bef_click_map[0],this.bef_click_map[1] ) == true ) &&
                        this.viewBord.isNariXY( this.bef_click_map[0],this.bef_click_map[1] ) == true ) {
                        if( window.confirm(this.message_select_nari)) {
                            nariMode = true ;
                        }
                        this.viewBord.refreshColor() ;
                    }
                    var res = this.viewBord.moveKoma( this.bef_click_map[0],this.bef_click_map[1],x,y,nariMode ) ;
                    if( res == null || res >= 0 ) {
                        this.viewBord.pushPosByGetKoma( mode,res ) ;
                        this.viewBord.refreshPosKoma( true ) ;
                        this.viewBord.refreshPosKoma( false ) ;
                        ret = true ;
                    }
                }
                this.bef_click_map = null ;
            }
            else {
                this.bef_click_map = null ;
            }
            if( ret == false ) {
                this.clear_view_map_over( this.bordClickColor,true ) ;
            }
            return ret ;
        }
        // 保有駒が選択されている.
        else if( this.viewBord.isUseKomaXY( x,y ) == false && this.bef_click_pos != null ) {
            var res = this.viewBord.posKomaToInsertBord( this.bef_click_pos[0],this.bef_click_pos[1],x,y ) ;
            this.clear_view_pos_click() ;
            if( res != -1 ) {
                return true ;
            }
            return false ;
        }
        if( this.isTypeByXY( x,y ) == false ) {
            return false ;
        }
        if( this.viewBord.isUseKomaXY( x,y ) == true ) {
            this.clear_view_pos_click() ;
            this.viewBord.setBordChipColor( x,y,this.bordClickColor ) ;
            this.bef_click_map = [x,y] ;
        }
        else {
            this.bef_click_map = null ;
        }
        return false ;
    },
    // 将棋盤マウスオーバ処理.
    over_map: function( x,y ) {
        // 条件が選択されていない,又は、選択可能情報ではない場合.
        if( this.bef_click_map == null && this.bef_click_pos == null &&
            ( this.viewBord.isUseKomaXY( x,y ) == false || this.isTypeByXY( x,y ) == false ) ) {
            // マウスオーバなし.
            this.clear_view_pos_over( this.bordOverColor ) ;
            return ;
        }
        if( this.bef_over_map != null ) {
            if( this.bef_click_map != null && this.bef_click_map[0] == this.bef_over_map[0] && this.bef_click_map[1] == this.bef_over_map[1] ) {
                this.viewBord.setBordChipColor( this.bef_click_map[0],this.bef_click_map[1],this.bordClickColor ) ;
            }
            else {
                this.clear_view_map_over( this.bordClickColor,true ) ;
            }
        }
        this.clear_view_pos_over( this.bordOverColor ) ;
        this.viewBord.setBordChipColor( x,y,this.posClickColor ) ;
        this.bef_over_map = [x,y] ;
    },
    // 保有駒クリック処理.
    click_pos: function( mode,no ) {
        if( this.isTypeByPos( mode ) == false ) {
            return ;
        }
        if( this.bef_click_pos != null && this.bef_click_pos[0] == mode && this.bef_click_pos[1] == no ) {
            this.clear_view_pos_click() ;
            return ;
        }
        if( this.viewBord.isPosKomaToInsertBord( mode,no ) == false ) {
            if( this.bef_click_pos != null ) {
                this.clear_view_pos_click() ;
            }
            return ;
        }
        if( this.bef_click_pos != null ) {
            this.clear_view_pos_click( true ) ;
        }
        this.viewBord.setPosColor( mode,no,this.bordOverColor ) ;
        this.bef_click_pos = [mode,no] ;
        this.clear_view_map_click() ;
    },
    // 保有駒マウスオーバ処理.
    over_pos: function( mode,no ) {
        if( this.isTypeByPos( mode ) == false ) {
            return ;
        }
        if( this.viewBord.isPosKomaToInsertBord( mode,no ) == true ) {
            if( this.bef_over_pos != null ) {
                if( this.bef_click_pos != null && this.bef_click_pos[0] == this.bef_over_pos[0] && this.bef_click_pos[1] == this.bef_over_pos[1] ) {
                    this.viewBord.setPosColor( this.bef_click_pos[0],this.bef_click_pos[1],this.bordOverColor ) ;
                }
                else {
                    this.clear_view_pos_over( this.bordOverColor,true ) ;
                }
            }
            this.clear_view_map_over( this.bordClickColor ) ;
            this.viewBord.setPosColor( mode,no,this.posOverColor ) ;
            this.bef_over_pos = [mode,no] ;
        }
    },
    // 将棋盤クリック表示内容を削除.
    clear_view_map_click: function(mode) {
        if( this.bef_click_map != null ) {
            this.viewBord.clearBordChipColor( this.bef_click_map[0],this.bef_click_map[1] ) ;
            if( mode != true ) {
                this.bef_click_map = null ;
            }
        }
    },
    // 将棋盤マウスオーバ表示内容を削除.
    clear_view_map_over: function(color,mode) {
        if( this.bef_over_map != null ) {
            this.viewBord.clearBordChipColor( this.bef_over_map[0],this.bef_over_map[1] ) ;
            if( this.bef_click_map != null ) {
                this.viewBord.setBordChipColor( this.bef_click_map[0],this.bef_click_map[1],color ) ;
            }
            if( mode != true ) {
                this.bef_over_map = null ;
            }
        }
    },
    // 保有駒クリック表示内容を削除.
    clear_view_pos_click: function(mode) {
        if( this.bef_click_pos != null ) {
            this.viewBord.clearPosColor( this.bef_click_pos[0],this.bef_click_pos[1] ) ;
            if( mode != true ) {
                this.bef_click_pos = null ;
            }
        }
    },
    // 保有駒マウスオーバ表示内容を削除.
    clear_view_pos_over: function(color,mode) {
        if( this.bef_over_pos != null ) {
            this.viewBord.clearPosColor( this.bef_over_pos[0],this.bef_over_pos[1] ) ;
            if( this.bef_click_pos != null ) {
                this.viewBord.setPosColor( this.bef_click_pos[0],this.bef_click_pos[1],color ) ;
            }
            if( mode != true ) {
                this.bef_over_pos = null ;
            }
        }
    },
    // 指定タイプに対して、ボード操作可能かチェック.
    isTypeByXY: function( x,y ) {
        if( this.type == null ) {
            return true ;
        }
        if( this.viewBord.isUseKomaXY( x,y ) == false ||
            this.viewBord.isUpKomaXY( x,y ) == this.type ) {
            return true ;
        }
        return false ;
    },
    // 指定タイプに対して、保有駒操作が可能かチェック.
    isTypeByPos: function( mode ) {
        if( this.type == null ) {
            return true ;
        }
        if( this.type == mode ) {
            return true ;
        }
        return false ;
    }
} ;

