package org.maachang.comet.httpd ;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

/**
 * HttpSocket.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public interface HttpSocket {
    
    /**
     * オブジェクト破棄.
     */
    public void destroy() ;
    
    /**
     * コネクションオブジェクトを設定.
     * <BR><BR>
     * コネクションオブジェクトを設定します.
     * <BR>
     * @param connectionInfo コネクションオブジェクトを設定します.
     */
    public void setConnectionInfo( HttpConnectionInfo connectionInfo ) ;
    
    /**
     * コネクションオブジェクトを取得.
     * <BR><BR>
     * コネクションオブジェクトを設定します.
     * <BR>
     * @return HttpConnectionInfo コネクションオブジェクトが返されます.
     */
    public HttpConnectionInfo getConnectionInfo() ;
    
    /**
     * 更新処理.
     * <BR><BR>
     * このオブジェクトを再利用するための更新処理を実施します.
     * <BR>
     * @exception Exception 例外.
     */
    public void update() throws Exception ;
    
    /**
     * 受信情報が存在するかチェック.
     * <BR><BR>
     * 受信情報が存在するかチェックします.
     * <BR>
     * @return boolean [true]の場合、受信情報が存在します.
     * @exception Exception 例外.
     */
    public boolean isReceive() throws Exception ;
    
    /**
     * ソケットオブジェクトを取得.
     * <BR><BR>
     * ソケットオブジェクトを取得します.
     * <BR>
     * @return Socket ソケットオブジェクトが返されます.
     */
    public Socket socket() ;
    
    /**
     * ソケット受信ストリームを取得.
     * <BR><BR>
     * ソケット受信ストリームを取得します.
     * <BR>
     * @return InputStream ソケット受信ストリームが返されます.
     * @exception Exception 例外.
     */
    public InputStream inputStream()
        throws Exception ;
    
    /**
     * ソケット送信ストリームを取得.
     * <BR><BR>
     * ソケット送信ストリームを取得します.
     * <BR>
     * @return OutputStream ソケット送信ストリームが返されます.
     */
    public OutputStream outputStream()
        throws Exception ;
    
    /**
     * 最終更新時間を取得.
     * <BR><BR>
     * 最終更新時間を取得します.
     * <BR>
     * @return long 最終更新時間が返されます.
     */
    public long time() ;
    
    /**
     * このソケットを利用後にクローズする場合は[true]が返されます.
     * <BR>
     * @return boolean [true]の場合、クローズされます.
     */
    public boolean isCloseFlag() ;
    
    /**
     * このソケットを利用後にクローズするか設定.
     * <BR><BR>
     * このソケットを利用後にクローズする場合は[true]を設定します.
     * <BR>
     * @param flag [true]の場合、利用終了後にクローズします.
     */
    public void setCloseFlag( boolean flag ) ;
    
    /**
     * クローズされているかチェック.
     * <BR>
     * @return boolean [true]の場合、このオブジェクトはクローズされています.
     */
    public boolean isClosed() ;
    
    /**
     * 受信開始時に呼び出す.
     */
    public void startReceive() ;
    
    /**
     * 受信(処理)完了時に呼び出す.
     */
    public void endReceive() ;
    
    /**
     * 現在までの受信時間を返す.
     * @return long 受信開始時間から現在までの時間を取得.
     */
    public long getReceiveStartTimeToNow() ;
}

